/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.Processor;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.WSDLModel;
import org.apache.cxf.tools.java2wsdl.generator.WSDLGenerator;
import org.apache.cxf.tools.java2wsdl.processor.internal.ClassProcessor;
import org.apache.cxf.tools.util.AnnotationUtil;

public class JavaToWSDLProcessor
implements Processor {
    private static final Logger LOG = LogUtils.getL7dLogger(JavaToWSDLProcessor.class);
    private WSDLModel model;
    private ToolContext penv;
    private Class seiClass;

    public void process() throws ToolException {
        try {
            this.model = new WSDLModel();
        }
        catch (Exception e) {
            Message msg = new Message("FAIL_TO_BUILD_WSDLMODEL", LOG, new Object[0]);
            LOG.log(Level.SEVERE, msg.toString());
            throw new ToolException(msg);
        }
        this.init();
        this.buildModel(this.model, this.getSEIClass());
        WSDLGenerator generator = new WSDLGenerator(this.model, this.penv);
        generator.generate();
    }

    public void buildModel(WSDLModel wmodel, Class clazz) throws ToolException {
        ClassProcessor classproc = new ClassProcessor(clazz, this.getEnvironment());
        classproc.process(wmodel);
    }

    public void setEnvironment(ToolContext env) {
        this.penv = env;
    }

    public ToolContext getEnvironment() {
        return this.penv;
    }

    protected void init() {
        if (this.penv.get("classpath") != null) {
            String newCp = (String)this.penv.get("classpath");
            String classpath = System.getProperty("java.class.path");
            System.setProperty("java.class.path", newCp + File.pathSeparator + classpath);
        }
        this.seiClass = AnnotationUtil.loadClass((String)((String)this.penv.get("classname")), (ClassLoader)(this.seiClass == null ? JavaToWSDLProcessor.class.getClassLoader() : this.getSEIClass().getClassLoader()));
    }

    protected Class getSEIClass() {
        return this.seiClass;
    }

    public WSDLModel getModel() {
        return this.model;
    }
}

