/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.OperationType;
import javax.xml.ws.Response;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.WSDLModel;
import org.apache.cxf.tools.java2wsdl.processor.JavaToWSDLProcessor;
import org.apache.cxf.tools.java2wsdl.processor.internal.DocBareMethodProcessor;
import org.apache.cxf.tools.java2wsdl.processor.internal.DocWrapperMethodProcessor;
import org.apache.cxf.tools.java2wsdl.processor.internal.RPCMethodProcessor;
import org.apache.cxf.tools.util.AnnotationUtil;
import org.apache.cxf.tools.util.URIParserUtil;

public class ClassProcessor {
    private static final Logger LOG = LogUtils.getL7dLogger(JavaToWSDLProcessor.class);
    Class seiClass;
    WSDLModel model;
    Map<Class, Boolean> useWebMethodClasses = new HashMap<Class, Boolean>();
    private final ToolContext env;

    public ClassProcessor(Class clz, ToolContext penv) {
        this.seiClass = clz;
        this.env = penv;
    }

    public void process(WSDLModel wmodel) {
        this.model = wmodel;
        this.populateWSDLInfo(this.seiClass);
        this.checkWebMethodUseClass(this.seiClass);
        for (Method method : this.seiClass.getMethods()) {
            if (method.getDeclaringClass().equals(Object.class) || !this.isOperationToGen(method, this.seiClass)) continue;
            this.processMethod(wmodel, method);
        }
    }

    private void processMethod(WSDLModel wmodel, Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return;
        }
        WebMethod webMethod = (WebMethod)AnnotationUtil.getPrivMethodAnnotation((Method)method, WebMethod.class);
        if (webMethod != null && webMethod.exclude()) {
            return;
        }
        JavaMethod javaMethod = new JavaMethod();
        String operationName = method.getName();
        if (!method.getDeclaringClass().equals(this.seiClass)) {
            try {
                Method tmp = this.seiClass.getMethod(method.getName(), method.getParameterTypes());
                operationName = tmp.getName();
            }
            catch (NoSuchMethodException e) {
                throw new ToolException(e.getMessage(), (Throwable)e);
            }
        }
        if (webMethod != null) {
            operationName = webMethod.operationName().length() > 0 ? webMethod.operationName() : operationName;
            javaMethod.setSoapAction(webMethod.action());
        }
        javaMethod.setName(operationName);
        if (this.isAsynMethod(method)) {
            return;
        }
        if (this.isOneWayMethod(method)) {
            javaMethod.setStyle(OperationType.ONE_WAY);
        } else {
            javaMethod.setStyle(OperationType.REQUEST_RESPONSE);
        }
        switch (this.getMethodType(method)) {
            case 2: {
                DocBareMethodProcessor docBareProcessor = new DocBareMethodProcessor(this.model);
                docBareProcessor.processDocBare(javaMethod, method);
                break;
            }
            case 1: {
                DocWrapperMethodProcessor docWrapperProcessor = new DocWrapperMethodProcessor(this.model);
                docWrapperProcessor.process(javaMethod, method);
                break;
            }
            case 3: {
                RPCMethodProcessor rpcMethodProcessor = new RPCMethodProcessor(this.model);
                rpcMethodProcessor.process(javaMethod, method);
                break;
            }
            default: {
                Message message = new Message("SOAPUSESTYLE_PARAMETERSTYLE_ERROR", LOG, new Object[]{method.getName()});
                throw new ToolException(message);
            }
        }
        wmodel.addJavaMethod(javaMethod);
    }

    private int getMethodType(Method method) {
        SOAPBinding binding = method.getAnnotation(SOAPBinding.class);
        int result = -1;
        if (binding != null) {
            if (binding.style() == SOAPBinding.Style.RPC) {
                Message message = new Message("SOAPBinding_RPC_ON_METHOD", LOG, new Object[]{method.getName()});
                throw new ToolException(message);
            }
            if (binding.style() == SOAPBinding.Style.DOCUMENT && binding.parameterStyle() == SOAPBinding.ParameterStyle.WRAPPED) {
                result = 1;
            }
            if (binding.style() == SOAPBinding.Style.DOCUMENT && binding.parameterStyle() == SOAPBinding.ParameterStyle.BARE) {
                result = 2;
            }
        } else {
            if (this.model.isRPC() && this.model.isWrapped()) {
                result = 3;
            }
            if (this.model.isDocLit() && this.model.isWrapped()) {
                result = 1;
            }
            if (this.model.isDocLit() && !this.model.isWrapped()) {
                result = 2;
            }
        }
        return result;
    }

    private boolean isOperationToGen(Method method, Class clazz) {
        if (clazz.isInterface()) {
            return true;
        }
        Class<?> declareClass = method.getDeclaringClass();
        WebMethod webMethod = (WebMethod)AnnotationUtil.getPrivMethodAnnotation((Method)method, WebMethod.class);
        if (webMethod != null && !webMethod.exclude()) {
            return true;
        }
        return AnnotationUtil.getPrivClassAnnotation(declareClass, WebService.class) != null && this.useWebMethodClasses.get(declareClass) == false;
    }

    private void checkWebMethodUseClass(Class clz) {
        if (clz == null) {
            return;
        }
        if (clz.isInterface()) {
            this.useWebMethodClasses.put(clz, false);
        } else {
            boolean existWebMethod = false;
            for (Method method : clz.getMethods()) {
                WebMethod webMethod;
                if (!method.getDeclaringClass().equals(this.seiClass) || (webMethod = (WebMethod)AnnotationUtil.getPrivMethodAnnotation((Method)method, WebMethod.class)) == null || webMethod.exclude()) continue;
                existWebMethod = true;
                break;
            }
            this.useWebMethodClasses.put(clz, existWebMethod);
        }
        this.checkWebMethodUseClass(clz.getSuperclass());
    }

    private void populateWSDLInfo(Class clazz) {
        WebService webService = (WebService)AnnotationUtil.getPrivClassAnnotation((Class)clazz, WebService.class);
        if (webService == null) {
            Message message = new Message("SEI_CLASS_NO_WEBSERVICE_ANNOTATED", LOG, new Object[0]);
            throw new ToolException(message);
        }
        if (webService.endpointInterface().length() > 0 && (webService = (WebService)AnnotationUtil.getPrivClassAnnotation((Class)(clazz = AnnotationUtil.loadClass((String)webService.endpointInterface(), (ClassLoader)clazz.getClassLoader())), WebService.class)) == null) {
            Message message = new Message("SEI_INTERFACE_NO_WEBSERVICE_ANNOTATED", LOG, new Object[0]);
            throw new ToolException(message);
        }
        String portTypeName = clazz.getSimpleName() + "PortType";
        if (webService.name().length() > 0) {
            portTypeName = webService.name();
        }
        this.model.setPortTypeName(portTypeName);
        String portName = clazz.getSimpleName() + "Port";
        if (webService.portName().length() > 0) {
            portName = webService.portName();
        } else if (webService.name().length() > 0) {
            portName = webService.name() + "Port";
        }
        this.model.setPortName(portName);
        String serviceName = clazz.getSimpleName() + "Service";
        if (this.env.optionSet("servicename")) {
            serviceName = (String)this.env.get("servicename");
        } else if (webService.serviceName().length() > 0) {
            serviceName = webService.serviceName();
        }
        this.model.setServiceName(serviceName);
        String packageName = PackageUtils.getPackageName((Class)clazz);
        this.model.setPackageName(packageName);
        String targetNamespace = URIParserUtil.getNamespace((String)packageName);
        if (this.env.optionSet("tns")) {
            targetNamespace = (String)this.env.get("tns");
        } else if (webService.targetNamespace().length() > 0) {
            targetNamespace = webService.targetNamespace();
        } else if (targetNamespace == null) {
            Message message = new Message("SEI_CLASS_HASNO_PACKAGE", LOG, new Object[0]);
            throw new ToolException(message);
        }
        this.model.setTargetNameSpace(targetNamespace);
        String wsdlLocation = webService.wsdlLocation();
        this.model.setWsdllocation(wsdlLocation);
        SOAPBinding soapBinding = (SOAPBinding)AnnotationUtil.getPrivClassAnnotation((Class)clazz, SOAPBinding.class);
        if (soapBinding != null) {
            this.model.setStyle(soapBinding.style());
            this.model.setUse(soapBinding.use());
            this.model.setPrameterStyle(soapBinding.parameterStyle());
        }
    }

    private boolean isAsynMethod(Method method) {
        return method.getReturnType().equals(Future.class) && method.getName().endsWith("Async") || method.getReturnType().equals(Response.class) && method.getName().endsWith("Async");
    }

    private boolean isOneWayMethod(Method method) {
        return method.isAnnotationPresent(Oneway.class);
    }
}

