/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal;

import com.sun.xml.bind.api.TypeReference;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.jws.Oneway;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import javax.xml.ws.WebFault;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.JavaType;
import org.apache.cxf.tools.common.model.WSDLException;
import org.apache.cxf.tools.common.model.WSDLModel;
import org.apache.cxf.tools.common.model.WSDLParameter;
import org.apache.cxf.tools.java2wsdl.processor.JavaToWSDLProcessor;
import org.apache.cxf.tools.util.AnnotationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocWrapperMethodProcessor {
    private static final Logger LOG = LogUtils.getL7dLogger(JavaToWSDLProcessor.class);
    private WSDLModel model;

    public DocWrapperMethodProcessor(WSDLModel wmodel) {
        this.model = wmodel;
    }

    public void process(JavaMethod javaMethod, Method method) {
        if (this.model.getStyle() != SOAPBinding.Style.DOCUMENT) {
            this.model.setStyle(SOAPBinding.Style.DOCUMENT);
        }
        javaMethod.setSoapStyle(SOAPBinding.Style.DOCUMENT);
        javaMethod.setWrapperStyle(true);
        this.setMethodUse(javaMethod, method);
        RequestWrapper reqWrapper = method.getAnnotation(RequestWrapper.class);
        String reqClassName = "";
        String reqName = method.getName();
        String reqNS = this.model.getTargetNameSpace();
        if (reqWrapper != null && !StringUtils.isEmpty((String)reqWrapper.className())) {
            reqClassName = reqWrapper.className().length() > 0 ? reqWrapper.className() : reqClassName;
            reqName = reqWrapper.localName().length() > 0 ? reqWrapper.localName() : reqName;
            reqNS = reqWrapper.targetNamespace().length() > 0 ? reqWrapper.targetNamespace() : reqNS;
        } else {
            reqClassName = this.model.getPackageName() + ".jaxws." + AnnotationUtil.capitalize((String)method.getName());
        }
        Class reqClass = null;
        try {
            reqClass = AnnotationUtil.loadClass((String)reqClassName, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (Exception e) {
            Message msg = new Message("LOAD_REQUEST_WRAPPER_CLASS_ERROR", LOG, new Object[]{reqClassName});
            throw new ToolException(msg, (Throwable)e);
        }
        QName reqQN = new QName(reqNS, reqName);
        TypeReference typeRef = new TypeReference(reqQN, (Type)reqClass, new Annotation[0]);
        WSDLParameter request = new WSDLParameter(reqName, typeRef, JavaType.Style.IN);
        request.setTargetNamespace(reqNS);
        javaMethod.addRequest(request);
        if (!this.isOneWayMethod(method)) {
            ResponseWrapper resWrapper = method.getAnnotation(ResponseWrapper.class);
            String resClassName = "";
            String resName = method.getName() + "Response";
            String resNS = this.model.getTargetNameSpace();
            if (resWrapper != null && !StringUtils.isEmpty((String)resWrapper.className())) {
                resClassName = resWrapper.className();
                resName = resWrapper.localName().length() > 0 ? resWrapper.localName() : resName;
                resNS = resWrapper.targetNamespace().length() > 0 ? resWrapper.targetNamespace() : resNS;
            } else {
                resClassName = this.model.getPackageName() + ".jaxws." + AnnotationUtil.capitalize((String)method.getName()) + "Response";
            }
            Class resClass = null;
            QName resQN = new QName(resNS, resName);
            try {
                resClass = AnnotationUtil.loadClass((String)resClassName, (ClassLoader)method.getDeclaringClass().getClassLoader());
            }
            catch (Exception e) {
                Message msg = new Message("LOAD_RESPONSE_WRAPPER_CLASS_ERROR", LOG, new Object[]{resClassName});
                throw new ToolException(msg, (Throwable)e);
            }
            typeRef = new TypeReference(resQN, (Type)resClass, new Annotation[0]);
            WSDLParameter response = new WSDLParameter(resName, typeRef, JavaType.Style.OUT);
            response.setTargetNamespace(resNS);
            javaMethod.addResponse(response);
            WebResult webResult = method.getAnnotation(WebResult.class);
            JavaParameter returnParameter = this.getReturnParameter(webResult, method);
            if (returnParameter != null) {
                response.addChildren(returnParameter);
            }
        }
        List<JavaParameter> paras = this.processWebPara(method);
        for (JavaParameter jp : paras) {
            if (jp.getStyle() == JavaType.Style.IN) {
                request.addChildren(jp);
                continue;
            }
            request.addChildren(jp);
        }
        this.processExceptions(javaMethod, method);
    }

    private void setMethodUse(JavaMethod javaMethod, Method method) {
        SOAPBinding binding = method.getAnnotation(SOAPBinding.class);
        if (binding != null) {
            javaMethod.setSoapUse(binding.use());
        } else {
            javaMethod.setSoapUse(this.model.getUse());
        }
    }

    private List<JavaParameter> processWebPara(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] parameterGenTypes = method.getGenericParameterTypes();
        Annotation[][] paraAnns = AnnotationUtil.getPrivParameterAnnotations((Method)method);
        ArrayList<JavaParameter> paras = new ArrayList<JavaParameter>();
        int i = 0;
        JavaParameter jp = null;
        for (Class clazz : parameterTypes) {
            String paraName = method.getName();
            String partName = "arg" + i;
            String paraTNS = this.model.getTargetNameSpace();
            Class clazz2 = clazz;
            boolean holder = this.isHolder(clazz);
            if (holder) {
                clazz2 = this.getHoldedClass(clazz, parameterGenTypes[i]);
            }
            for (Annotation anno : paraAnns[i]) {
                if (anno.annotationType() != WebParam.class) continue;
                WebParam webParam = (WebParam)anno;
                paraName = webParam.name().length() > 0 ? webParam.name() : paraName;
                partName = webParam.partName().length() > 0 ? webParam.partName() : paraName;
                paraTNS = webParam.targetNamespace().length() > 0 ? webParam.targetNamespace() : paraTNS;
                QName requestQN = new QName(paraTNS, paraName);
                TypeReference typeref = new TypeReference(requestQN, (Type)clazz2, paraAnns[i]);
                jp = holder ? (webParam.mode() == WebParam.Mode.INOUT ? new JavaParameter(typeref.tagName.getLocalPart(), typeref, JavaType.Style.INOUT) : new JavaParameter(typeref.tagName.getLocalPart(), typeref, JavaType.Style.OUT)) : new JavaParameter(typeref.tagName.getLocalPart(), typeref, JavaType.Style.IN);
                jp.setName(paraName);
                jp.setPartName(partName);
                jp.setHeader(webParam.header());
                jp.setTargetNamespace(paraTNS);
            }
            if (paraAnns[i].length == 0) {
                TypeReference typeref = new TypeReference(new QName(paraTNS, paraName), (Type)clazz2, paraAnns[i]);
                jp = new JavaParameter(typeref.tagName.getLocalPart(), typeref, JavaType.Style.IN);
                jp.setPartName(partName);
                jp.setTargetNamespace(paraTNS);
            }
            paras.add(jp);
            ++i;
        }
        return paras;
    }

    private void processExceptions(JavaMethod jmethod, Method method) {
        for (Type exception : method.getGenericExceptionTypes()) {
            if (RemoteException.class.isAssignableFrom((Class)exception)) continue;
            Annotation[] anns = null;
            Class exClass = (Class)exception;
            String exNameSpace = this.model.getTargetNameSpace();
            String exName = exClass.getSimpleName();
            Class<?> exReturnType = null;
            Method faultInfo = null;
            try {
                faultInfo = exClass.getMethod("getFaultInfo", new Class[0]);
            }
            catch (SecurityException e) {
                throw new ToolException(e.getMessage(), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new ToolException(e.getMessage(), (Throwable)e);
            }
            if (faultInfo != null) {
                WebFault wf = exClass.getAnnotation(WebFault.class);
                exReturnType = faultInfo.getReturnType();
                anns = faultInfo.getAnnotations();
                if (wf.targetNamespace().length() > 0) {
                    exNameSpace = wf.targetNamespace();
                }
                exName = wf.name();
            }
            QName exQName = new QName(exNameSpace, exName);
            TypeReference tf = new TypeReference(exQName, exReturnType, anns);
            WSDLException wsdlEx = new WSDLException(exClass, tf);
            jmethod.addWSDLException(wsdlEx);
        }
    }

    private boolean isHolder(Class cType) {
        return Holder.class.isAssignableFrom(cType);
    }

    private Class getHoldedClass(Class holderClazz, Type type) {
        ParameterizedType pt = (ParameterizedType)type;
        return this.getClass(pt.getActualTypeArguments()[0]);
    }

    private Class getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gt = (GenericArrayType)type;
            Class compType = this.getClass(gt.getGenericComponentType());
            return Array.newInstance(compType, 0).getClass();
        }
        return Object.class;
    }

    private boolean isOneWayMethod(Method method) {
        return method.isAnnotationPresent(Oneway.class);
    }

    private JavaParameter getReturnParameter(WebResult webResult, Method method) {
        boolean isHeader = false;
        String resultName = "Return";
        String resultTNS = this.model.getTargetNameSpace();
        JavaParameter jpara = null;
        QName resultQName = null;
        if (webResult != null) {
            resultName = webResult.name().length() > 0 && webResult.partName().length() > 0 ? webResult.partName() : resultName;
            resultName = webResult.name().length() > 0 ? webResult.name() : resultName;
            resultName = webResult.partName().length() > 0 ? webResult.partName() : resultName;
            resultTNS = webResult.targetNamespace().length() > 0 ? webResult.targetNamespace() : resultTNS;
            isHeader = webResult.header();
        }
        resultQName = new QName(resultTNS, resultName);
        Class<?> returnType = method.getReturnType();
        if (resultQName != null && !this.isOneWayMethod(method) && returnType != null && !"void".equals(returnType.getName())) {
            Annotation[] annotations = new Annotation[]{};
            if (resultQName.getLocalPart() != null) {
                TypeReference rTypeReference = new TypeReference(resultQName, returnType, annotations);
                jpara = new JavaParameter();
                jpara.setName(method.getName() + "Response");
                jpara.setTypeReference(rTypeReference);
                jpara.setStyle(JavaType.Style.OUT);
                jpara.setHeader(isHeader);
            }
        }
        return jpara;
    }
}

