/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.spring;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.configuration.spring.JaxbClassPathXmlApplicationContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.wiring.BeanConfigurerSupport;
import org.springframework.beans.factory.wiring.BeanWiringInfo;
import org.springframework.beans.factory.wiring.BeanWiringInfoResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;

public class ConfigurerImpl
extends BeanConfigurerSupport
implements Configurer {
    private static final Logger LOG = LogUtils.getL7dLogger(ConfigurerImpl.class);
    private static final String DEFAULT_USER_CFG_FILE = "cxf.xml";
    private ApplicationContext appContext;

    public ConfigurerImpl() {
        this(DEFAULT_USER_CFG_FILE);
    }

    public ConfigurerImpl(String cfgFile) {
        ClassPathResource cpr;
        if (null == cfgFile) {
            cfgFile = System.getProperty("cxf.config.file");
        }
        if (null == cfgFile) {
            cfgFile = DEFAULT_USER_CFG_FILE;
        }
        if ((cpr = new ClassPathResource(cfgFile)).exists()) {
            try {
                JaxbClassPathXmlApplicationContext ac = new JaxbClassPathXmlApplicationContext(cfgFile);
                this.setApplicationContext((ApplicationContext)ac);
            }
            catch (BeansException ex) {
                LogUtils.log(LOG, Level.WARNING, "APP_CONTEXT_CREATION_FAILED_MSG", (Throwable)ex, (Object[])null);
            }
        } else {
            LOG.log(Level.INFO, new Message("USER_CFG_FILE_NOT_FOUND_MSG", LOG, cfgFile).toString());
        }
    }

    public ConfigurerImpl(ApplicationContext ac) {
        this.setApplicationContext(ac);
    }

    public void configureBean(Object beanInstance) {
        if (null == this.appContext) {
            return;
        }
        final String beanName = this.getBeanName(beanInstance);
        if (null == beanName) {
            return;
        }
        this.setBeanWiringInfoResolver(new BeanWiringInfoResolver(){

            public BeanWiringInfo resolveWiringInfo(Object instance) {
                if (null != beanName && !"".equals(beanName)) {
                    return new BeanWiringInfo(beanName);
                }
                return null;
            }
        });
        try {
            super.configureBean(beanInstance);
            LOG.fine("Successfully performed injection.");
        }
        catch (NoSuchBeanDefinitionException ex) {
            LogUtils.log(LOG, Level.INFO, "NO_MATCHING_BEAN_MSG", new Object[]{beanName});
            LOG.log(Level.INFO, "NO_MATCHING_BEAN_MSG", beanName);
        }
    }

    protected String getBeanName(Object beanInstance) {
        if (beanInstance instanceof Configurable) {
            return ((Configurable)beanInstance).getBeanName();
        }
        String beanName = null;
        try {
            Method m = beanInstance.getClass().getDeclaredMethod("getBeanName", null);
            beanName = (String)m.invoke(beanInstance, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (Exception ex) {
            LogUtils.log(LOG, Level.WARNING, "ERROR_DETERMINING_BEAN_NAME_EXC", (Throwable)ex, new Object[0]);
        }
        if (null == beanName) {
            LogUtils.log(LOG, Level.INFO, "COULD_NOT_DETERMINE_BEAN_NAME_MSG", new Object[]{beanInstance.getClass().getName()});
        }
        return beanName;
    }

    private void setApplicationContext(ApplicationContext ac) {
        this.appContext = ac;
        this.setBeanFactory((BeanFactory)this.appContext.getAutowireCapableBeanFactory());
    }
}

