/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.jmx;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.management.Instrumentation;
import org.apache.cxf.management.JMXConnectorPolicyType;
import org.apache.cxf.management.jmx.JMXUtils;
import org.apache.cxf.management.jmx.MBServerConnectorFactory;
import org.apache.cxf.management.jmx.export.runtime.ModelMBeanAssembler;

public class JMXManagedComponentManager {
    private static final Logger LOG = LogUtils.getL7dLogger(JMXManagedComponentManager.class);
    private boolean platformMBeanServer;
    private ModelMBeanAssembler mbAssembler = new ModelMBeanAssembler();
    private MBServerConnectorFactory mcf;
    private MBeanServer mbs;

    public void init(JMXConnectorPolicyType cp) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Setting up MBeanServer ");
        }
        this.mbs = MBeanServerFactory.createMBeanServer("org.apache.cxf.instrumentation");
        this.mcf = MBServerConnectorFactory.getInstance();
        this.mcf.setMBeanServer(this.mbs);
        this.mcf.setThreaded(cp.isThreaded());
        this.mcf.setDaemon(cp.isDaemon());
        this.mcf.setServiceUrl(cp.getJMXServiceURL());
        try {
            this.mcf.createConnector();
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "START_CONNECTOR_FAILURE_MSG", new Object[]{ex});
        }
    }

    public MBeanServer getMBeanServer() {
        return this.mbs;
    }

    public void shutdown() {
        if (!this.platformMBeanServer) {
            try {
                this.mcf.destroy();
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, "STOP_CONNECTOR_FAILURE_MSG", new Object[]{ex});
            }
        }
    }

    public void registerMBean(Object object, ObjectName name) {
        try {
            this.mbs.registerMBean(object, name);
        }
        catch (InstanceAlreadyExistsException e) {
            try {
                this.mbs.unregisterMBean(name);
                this.mbs.registerMBean(object, name);
            }
            catch (Exception e1) {
                LOG.log(Level.SEVERE, "REGISTER_FAILURE_MSG", new Object[]{name, e1});
            }
        }
        catch (MBeanRegistrationException e) {
            LOG.log(Level.SEVERE, "REGISTER_FAILURE_MSG", new Object[]{name, e});
        }
        catch (NotCompliantMBeanException e) {
            LOG.log(Level.SEVERE, "REGISTER_FAILURE_MSG", new Object[]{name, e});
        }
    }

    public void unregisterMBean(ObjectName name) {
        try {
            this.mbs.unregisterMBean(name);
        }
        catch (JMException e) {
            LOG.log(Level.SEVERE, "UNREGISTER_FAILURE_MSG", new Object[]{name, e});
        }
    }

    public void registerMBean(Instrumentation instrumentation) {
        ModelMBeanInfo mbi = this.mbAssembler.getModelMbeanInfo(instrumentation.getClass());
        if (mbi != null) {
            try {
                RequiredModelMBean rtMBean = (RequiredModelMBean)this.mbs.instantiate("javax.management.modelmbean.RequiredModelMBean");
                rtMBean.setModelMBeanInfo(mbi);
                rtMBean.setManagedResource(instrumentation, "ObjectReference");
                this.registerMBean(rtMBean, JMXUtils.getObjectName(instrumentation.getInstrumentationName(), instrumentation.getUniqueInstrumentationName()));
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("registered the object to MBserver " + instrumentation.getUniqueInstrumentationName());
                }
            }
            catch (ReflectionException e) {
                LOG.log(Level.SEVERE, "INSTANTIANTE_FAILURE_MSG", new Object[]{e});
            }
            catch (MBeanException e) {
                LOG.log(Level.SEVERE, "MBEAN_FAILURE_MSG", new Object[]{e});
            }
            catch (InstanceNotFoundException e) {
                LOG.log(Level.SEVERE, "SET_MANAGED_RESOURCE_FAILURE_MSG", new Object[]{e});
            }
            catch (InvalidTargetObjectTypeException e) {
                LOG.log(Level.SEVERE, "SET_MANAGED_RESOURCE_FAILURE_MSG", new Object[]{e});
            }
        } else {
            LOG.log(Level.SEVERE, "GET_MANAGED_INFORMATION_FAILURE_MSG", new Object[]{instrumentation.getInstrumentationName()});
        }
    }

    public void unregisterMBean(Instrumentation instrumentation) {
        ObjectName name = JMXUtils.getObjectName(instrumentation.getInstrumentationName(), instrumentation.getUniqueInstrumentationName());
        this.unregisterMBean(name);
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("unregistered the object to MBserver" + instrumentation.getUniqueInstrumentationName());
        }
    }
}

