/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import org.apache.cxf.binding.attachment.AttachmentDataSource;
import org.apache.cxf.binding.attachment.AttachmentImpl;
import org.apache.cxf.binding.attachment.CachedOutputStream;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.io.AbstractCachedOutputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;

public class AttachmentDeserializer {
    public static final String ATTACHMENT_DIRECTORY = "attachment-directory";
    public static final String ATTACHMENT_MEMORY_THRESHOLD = "attachment-memory-threshold";
    public static final int THRESHHOLD = 102400;
    private PushbackInputStream stream;
    private String boundary;
    private String contentType;
    private List<CachedOutputStream> cache;
    private Message message;

    public AttachmentDeserializer(Message messageParam) {
        this.message = messageParam;
    }

    public boolean preprocessMessage() {
        try {
            Map httpHeaders = (Map)this.message.get((Object)Message.PROTOCOL_HEADERS);
            if (httpHeaders == null) {
                return false;
            }
            List ctList = HttpHeaderHelper.getHeader((Map)httpHeaders, (String)"Content-Type");
            if (ctList != null) {
                for (int x = 0; x < ctList.size(); ++x) {
                    this.contentType = x == 0 ? (String)ctList.get(x) : this.contentType + "; " + (String)ctList.get(x);
                }
            }
            if (this.contentType == null) {
                return false;
            }
            InputStream input = (InputStream)this.message.getContent(InputStream.class);
            if (input == null) {
                return false;
            }
            if (this.contentType.toLowerCase().indexOf("multipart/related") != -1) {
                int len;
                int end;
                this.cache = new ArrayList<CachedOutputStream>();
                int i = this.contentType.indexOf("boundary=\"");
                if (i == -1) {
                    i = this.contentType.indexOf("boundary=");
                    end = this.contentType.indexOf(";", i + 9);
                    if (end == -1) {
                        end = this.contentType.length();
                    }
                    len = 9;
                } else {
                    end = this.contentType.indexOf("\"", i + 10);
                    len = 10;
                }
                if (i == -1 || end == -1) {
                    throw new IOException("Invalid content type: missing boundary! " + this.contentType);
                }
                this.boundary = "--" + this.contentType.substring(i + len, end);
                this.stream = new PushbackInputStream(input, this.boundary.length());
                if (!AttachmentDeserializer.readTillFirstBoundary(this.stream, this.boundary.getBytes())) {
                    throw new IOException("Couldn't find MIME boundary: " + this.boundary);
                }
                this.processSoapBody();
                return true;
            }
        }
        catch (IOException ioe) {
            this.message.setContent(Exception.class, (Object)ioe);
        }
        catch (MessagingException me) {
            this.message.setContent(Exception.class, (Object)me);
        }
        return false;
    }

    public void dispose() {
        if (this.cache != null) {
            for (CachedOutputStream cos : this.cache) {
                cos.dispose();
            }
        }
    }

    public void process() throws MessagingException, IOException {
        this.processSoapBody();
        this.processAttachments();
    }

    public void processSoapBody() throws MessagingException, IOException {
        Attachment soapMimePart = this.readMimePart();
        this.message.setContent(Attachment.class, (Object)soapMimePart);
        InputStream in = soapMimePart.getDataHandler().getInputStream();
        this.message.setContent(InputStream.class, (Object)in);
    }

    public void processAttachments() throws MessagingException, IOException {
        Collection attachments = this.message.getAttachments();
        Attachment att = this.readMimePart();
        while (att != null && att.getId() != null) {
            attachments.add(att);
            att = this.readMimePart();
        }
    }

    public Attachment getAttachment(String cid) throws MessagingException, IOException {
        Collection attachments = this.message.getAttachments();
        for (Attachment att : attachments) {
            if (!att.getId().equals(cid)) continue;
            return att;
        }
        Attachment att = this.readMimePart();
        while (att != null && att.getId() != null) {
            String convertId;
            attachments.add(att);
            String string = convertId = cid.substring(0, 4).equals("cid:") ? cid.substring(4) : cid;
            if (att.getId().equals(convertId)) {
                return att;
            }
            att = this.readMimePart();
        }
        return null;
    }

    private static boolean readTillFirstBoundary(PushbackInputStream pbs, byte[] bp) throws IOException {
        int value = pbs.read();
        pbs.unread(value);
        while (value != -1) {
            int boundaryIndex;
            value = pbs.read();
            if ((byte)value != bp[0]) continue;
            for (boundaryIndex = 0; value != -1 && boundaryIndex < bp.length && (byte)value == bp[boundaryIndex]; ++boundaryIndex) {
                value = pbs.read();
                if (value != -1) continue;
                throw new IOException("Unexpected End while searching for first Mime Boundary");
            }
            if (boundaryIndex != bp.length) continue;
            pbs.read();
            return true;
        }
        return false;
    }

    private Attachment readMimePart() throws MessagingException, IOException {
        int v = this.stream.read();
        if (v == -1) {
            return null;
        }
        this.stream.unread(v);
        InternetHeaders iheaders = new InternetHeaders((InputStream)this.stream);
        HashMap internalHeaders = new HashMap();
        Enumeration e = iheaders.getAllHeaders();
        while (e.hasMoreElements()) {
            Header header = (Header)e.nextElement();
            ArrayList<String> values = new ArrayList<String>();
            String headerName = HttpHeaderHelper.getHeaderKey((String)header.getName());
            internalHeaders.put(headerName, values);
            values.add(header.getValue());
        }
        MimeBodyPartInputStream partStream = new MimeBodyPartInputStream(this.stream, this.boundary.getBytes());
        CachedOutputStream cos = new CachedOutputStream();
        cos.setThreshold(102400L);
        AbstractCachedOutputStream.copyStream((InputStream)partStream, (OutputStream)((Object)cos), (int)102400);
        cos.close();
        String ct = AttachmentDeserializer.constructHeaderValue(HttpHeaderHelper.getHeader(internalHeaders, (String)"Content-Type"));
        this.cache.add(cos);
        AttachmentDataSource source = new AttachmentDataSource(ct, cos);
        DataHandler dh = new DataHandler((DataSource)source);
        String id = (String)((List)internalHeaders.get(HttpHeaderHelper.getHeaderKey((String)"Content-ID"))).get(0);
        if (id != null && id.startsWith("<")) {
            id = id.substring(1, id.length() - 1);
        }
        AttachmentImpl att = new AttachmentImpl(id, dh);
        for (String headerName : internalHeaders.keySet()) {
            List values = (List)internalHeaders.get(headerName);
            if (headerName.equalsIgnoreCase("Content-Transfer-Encoding") && values.size() == 1 && values.get(0).equals("binary")) {
                att.setXOP(true);
            }
            att.setHeader(headerName, AttachmentDeserializer.constructHeaderValue(values));
        }
        return att;
    }

    private static String constructHeaderValue(List values) {
        StringBuffer sb = new StringBuffer(200);
        for (int i = 0; i < values.size(); ++i) {
            sb.append(values.get(i));
        }
        return sb.toString();
    }

    protected static void printStream(InputStream in) throws IOException {
        int i = in.read();
        while (i != -1) {
            System.out.write(i);
            i = in.read();
        }
        System.out.println("print stream");
    }

    private class MimeBodyPartInputStream
    extends InputStream {
        PushbackInputStream inStream;
        boolean boundaryFound;
        byte[] boundary;

        public MimeBodyPartInputStream(PushbackInputStream inStreamParam, byte[] boundaryParam) {
            this.inStream = inStreamParam;
            this.boundary = boundaryParam;
        }

        public int read() throws IOException {
            int boundaryIndex;
            boolean needUnread0d0a = false;
            if (this.boundaryFound) {
                return -1;
            }
            int value = this.inStream.read();
            if (value == 13) {
                value = this.inStream.read();
                if (value != 10) {
                    this.inStream.unread(value);
                    return 13;
                }
                value = this.inStream.read();
                if ((byte)value != this.boundary[0]) {
                    this.inStream.unread(value);
                    this.inStream.unread(10);
                    return 13;
                }
                needUnread0d0a = true;
            } else if ((byte)value != this.boundary[0]) {
                return value;
            }
            for (boundaryIndex = 0; boundaryIndex < this.boundary.length && (byte)value == this.boundary[boundaryIndex]; ++boundaryIndex) {
                value = this.inStream.read();
            }
            if (boundaryIndex == this.boundary.length) {
                this.boundaryFound = true;
                if (this.inStream.read() == 45 && value == 45) {
                    this.inStream.read();
                    this.inStream.read();
                }
                return -1;
            }
            if (value != -1) {
                this.inStream.unread(value);
            }
            if (needUnread0d0a) {
                this.inStream.unread(this.boundary, 0, boundaryIndex);
                this.inStream.unread(10);
                value = 13;
            } else {
                this.inStream.unread(this.boundary, 1, boundaryIndex - 1);
                value = this.boundary[0];
            }
            return value;
        }
    }
}

