/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.attachment;

import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.binding.attachment.AttachmentUtil;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.AbstractCachedOutputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;

public class AttachmentSerializer {
    private Message message;
    private InputStream in;
    private OutputStream out;

    public AttachmentSerializer(Message messageParam, InputStream inParam, OutputStream outParam) {
        this.message = messageParam;
        this.in = inParam;
        this.out = outParam;
    }

    public String serializeMultipartMessage() {
        String soapPartId;
        String boundary = AttachmentUtil.getUniqueBoundaryValue(0);
        try {
            soapPartId = AttachmentUtil.createContentID(null);
        }
        catch (UnsupportedEncodingException e) {
            throw new Fault((Throwable)e);
        }
        try {
            HashMap<String, List<String>> headers = CastUtils.cast((Map)((Map)this.message.get((Object)Message.PROTOCOL_HEADERS)));
            if (headers == null) {
                headers = new HashMap<String, List<String>>();
                this.message.put((Object)Message.PROTOCOL_HEADERS, headers);
            }
            AttachmentUtil.setMimeRequestHeader(headers, this.message, soapPartId, "soap message with attachments", boundary);
            this.out.flush();
            String soapHeader = AttachmentUtil.getSoapPartHeader(this.message, soapPartId, "");
            this.out.write(("--" + boundary + "\r\n").getBytes());
            this.out.write(soapHeader.getBytes());
            AbstractCachedOutputStream.copyStream((InputStream)this.in, (OutputStream)this.out, (int)65536);
            for (Attachment att : this.message.getAttachments()) {
                soapHeader = AttachmentUtil.getAttchmentPartHeader(att);
                this.out.write(("--" + boundary + "\r\n").getBytes());
                this.out.write(soapHeader.getBytes());
                Object content = att.getDataHandler().getContent();
                if (content instanceof InputStream) {
                    InputStream insAtt = (InputStream)content;
                    AbstractCachedOutputStream.copyStream((InputStream)insAtt, (OutputStream)this.out, (int)65536);
                } else {
                    ObjectOutputStream oos = new ObjectOutputStream(this.out);
                    oos.writeObject(content);
                }
                this.out.write("\r\n".getBytes());
            }
            this.out.write(("--" + boundary + "--\r\n").getBytes());
            this.out.flush();
            List contentType = (List)headers.get(HttpHeaderHelper.getHeaderKey((String)"Content-Type"));
            StringBuffer sb = new StringBuffer(120);
            for (String s : contentType) {
                sb.append(s);
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }
}

