/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.attachment;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttachmentUtil {
    private AttachmentUtil() {
    }

    public static String createContentID(String ns) throws UnsupportedEncodingException {
        String cid = "cxf.apache.org";
        String name = UUID.randomUUID() + "@";
        if (ns != null && ns.length() > 0) {
            try {
                String host;
                URI uri = new URI(ns);
                cid = host = uri.toURL().getHost();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return null;
            }
            catch (MalformedURLException e) {
                cid = URLEncoder.encode(ns, "UTF-8");
            }
        }
        return name + cid;
    }

    public static String getUniqueBoundaryValue(int part) {
        StringBuffer s = new StringBuffer();
        s.append("----=_Part_").append(part++).append("_").append(s.hashCode()).append('.').append(System.currentTimeMillis());
        return s.toString();
    }

    public static String getSoapPartHeader(Message message, String soapPartId, String action) {
        StringBuffer buffer = new StringBuffer(200);
        buffer.append(HttpHeaderHelper.getHeaderKey((String)"Content-Type") + ": application/xop+xml; charset=utf-8; ");
        buffer.append("type=\"" + message.getAttachmentMimeType());
        if (action != null) {
            buffer.append("; action=" + action + "\"\r\n");
        } else {
            buffer.append("\"\r\n");
        }
        buffer.append("Content-Transfer-Encoding: binary\r\n");
        buffer.append("Content-ID: <" + soapPartId + ">\r\n\r\n");
        return buffer.toString();
    }

    public static String getAttchmentPartHeader(Attachment att) {
        StringBuffer buffer = new StringBuffer(200);
        buffer.append(HttpHeaderHelper.getHeaderKey((String)"Content-Type") + ": " + att.getDataHandler().getContentType() + ";\r\n");
        if (att.isXOP()) {
            buffer.append("Content-Transfer-Encoding: binary\r\n");
        }
        buffer.append("Content-ID: <" + att.getId() + ">\r\n\r\n");
        return buffer.toString();
    }

    public static void setMimeRequestHeader(Map<String, List<String>> reqHeaders, Message message, String soapPartId, String contentDesc, String boundary) {
        ArrayList<String> header1 = new ArrayList<String>();
        header1.add("1.0");
        reqHeaders.put("MIME-Version", header1);
        ArrayList<String> header2 = new ArrayList<String>();
        header2.add("Multipart/" + AttachmentUtil.getMimeSubType(message, soapPartId, boundary));
        reqHeaders.put(HttpHeaderHelper.getHeaderKey((String)"Content-Type"), header2);
        ArrayList<String> header3 = new ArrayList<String>();
        header3.add(contentDesc);
        reqHeaders.put("Content-Description", header3);
    }

    public static String getMimeSubType(Message message, String soapPartId, String boundary) {
        StringBuffer ct = new StringBuffer();
        ct.append("related; boundary=\"" + boundary + "\"; ");
        ct.append("type=\"application/xop+xml\"; ");
        ct.append("start=\"<" + soapPartId + ">\"; ");
        ct.append("start-info=" + message.getAttachmentMimeType());
        return ct.toString();
    }
}

