/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.cxf.extension;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.bus.cxf.extension.Extension;
import org.apache.cxf.bus.cxf.extension.ExtensionException;
import org.apache.cxf.bus.cxf.extension.ExtensionFragmentParser;
import org.apache.cxf.common.injection.ResourceInjector;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.extension.ExtensionManager;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.resource.SinglePropertyResolver;
import org.springframework.core.io.UrlResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionManagerImpl
implements ExtensionManager {
    public static final String EXTENSIONMANAGER_PROPERTY_NAME = "extensionManager";
    public static final String ACTIVATION_NAMESPACES_PROPERTY_NAME = "activationNamespaces";
    private final ClassLoader loader;
    private ResourceManager resourceManager;
    private Map<String, Collection<Extension>> deferred;
    private final Map<Class, Object> activated;

    public ExtensionManagerImpl(String resource, ClassLoader cl, Map<Class, Object> initialExtensions, ResourceManager rm) {
        this.loader = cl;
        this.activated = initialExtensions;
        this.resourceManager = rm;
        SinglePropertyResolver extensionManagerResolver = new SinglePropertyResolver(EXTENSIONMANAGER_PROPERTY_NAME, (Object)this);
        this.resourceManager.addResourceResolver((ResourceResolver)extensionManagerResolver);
        this.deferred = new HashMap<String, Collection<Extension>>();
        try {
            this.load(resource);
        }
        catch (IOException ex) {
            throw new ExtensionException(ex);
        }
    }

    public void activateViaNS(String namespaceURI) {
        Collection<Extension> extensions = this.deferred.get(namespaceURI);
        if (null == extensions) {
            return;
        }
        for (Extension e : extensions) {
            this.loadAndRegister(e);
        }
        extensions.clear();
        this.deferred.remove(namespaceURI);
    }

    final void load(String resource) throws IOException {
        Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(resource);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            UrlResource urlRes = new UrlResource(url);
            InputStream is = urlRes.getInputStream();
            this.loadFragment(is);
        }
    }

    final void loadFragment(InputStream is) {
        List<Extension> extensions = new ExtensionFragmentParser().getExtensions(is);
        for (Extension e : extensions) {
            this.processExtension(e);
        }
    }

    final void processExtension(Extension e) {
        if (!e.isDeferred()) {
            this.loadAndRegister(e);
        }
        Collection<String> namespaces = e.getNamespaces();
        for (String ns : namespaces) {
            Collection<Extension> extensions = this.deferred.get(ns);
            if (null == extensions) {
                extensions = new ArrayList<Extension>();
                this.deferred.put(ns, extensions);
            }
            extensions.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void loadAndRegister(Extension e) {
        Class cls = null;
        if (null != e.getInterfaceName() && !"".equals(e.getInterfaceName())) {
            cls = e.loadInterface(this.loader);
        }
        if (null != this.activated && null != cls && null != this.activated.get(cls)) {
            return;
        }
        Object obj = e.load(this.loader);
        Configurer configurer = (Configurer)this.activated.get(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(obj);
        }
        SinglePropertyResolver namespacesResolver = null;
        if (null != e.getNamespaces()) {
            namespacesResolver = new SinglePropertyResolver(ACTIVATION_NAMESPACES_PROPERTY_NAME, e.getNamespaces());
            this.resourceManager.addResourceResolver((ResourceResolver)namespacesResolver);
        }
        ResourceInjector injector = new ResourceInjector(this.resourceManager);
        try {
            injector.inject(obj);
        }
        finally {
            if (null != namespacesResolver) {
                this.resourceManager.removeResourceResolver((ResourceResolver)namespacesResolver);
            }
        }
        if (null != this.activated && null != e.getInterfaceName()) {
            this.activated.put(cls, obj);
        }
    }
}

