/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.spring.JaxbClassPathXmlApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class BusApplicationContext
extends JaxbClassPathXmlApplicationContext {
    private static final String DEFAULT_CXF_CFG_FILE = "META-INF/cxf/cxf.xml";
    private static final String DEFAULT_CXF_EXT_CFG_FILE = "classpath*:META-INF/cxf/cxf-extension-*.xml";
    private static final String CXF_PROPERTY_EDITORS_CFG_FILE = "classpath*:META-INF/cxf/cxf-property-editors.xml";
    private static final Logger LOG = LogUtils.getL7dLogger(BusApplicationContext.class);
    private boolean includeDefaults;
    private String cfgFile;

    BusApplicationContext(String cf, boolean include) {
        this(cf, include, null);
    }

    BusApplicationContext(String cf, boolean include, ApplicationContext parent) {
        super((String[])null, parent);
        this.cfgFile = cf;
        this.includeDefaults = include;
    }

    protected Resource[] getConfigResources() {
        ClassPathResource cpr;
        ArrayList<Object> resources = new ArrayList<Object>();
        if (this.includeDefaults) {
            try {
                PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(Thread.currentThread().getContextClassLoader());
                Collections.addAll(resources, resolver.getResources(DEFAULT_CXF_CFG_FILE));
                Collections.addAll(resources, resolver.getResources(DEFAULT_CXF_EXT_CFG_FILE));
                Collections.addAll(resources, resolver.getResources(CXF_PROPERTY_EDITORS_CFG_FILE));
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (null == this.cfgFile) {
            this.cfgFile = System.getProperty("cxf.config.file");
        }
        if (null == this.cfgFile) {
            this.cfgFile = "cxf.xml";
        }
        if ((cpr = new ClassPathResource(this.cfgFile)).exists()) {
            resources.add(cpr);
        } else {
            LOG.log(Level.INFO, new Message("USER_CFG_FILE_NOT_FOUND_MSG", LOG, new Object[]{this.cfgFile}).toString());
        }
        String cfgFileUrl = System.getProperty("cxf.config.file.url");
        if (null != cfgFileUrl) {
            try {
                UrlResource ur = new UrlResource(cfgFileUrl);
                if (ur.exists()) {
                    resources.add(ur);
                } else {
                    LOG.log(Level.INFO, new Message("USER_CFG_FILE_URL_NOT_FOUND_MSG", LOG, new Object[]{cfgFileUrl}).toString());
                }
            }
            catch (MalformedURLException e) {
                LOG.log(Level.WARNING, new Message("USER_CFG_FILE_URL_ERROR_MSG", LOG, new Object[]{cfgFileUrl}).toString());
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating application context with resources: " + resources);
        }
        if (0 == resources.size()) {
            return null;
        }
        Resource[] res = new Resource[resources.size()];
        res = resources.toArray(res);
        return res;
    }
}

