/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.MessageObserver;

public class ServerImpl
implements Server {
    private static final Logger LOG = Logger.getLogger(ServerImpl.class.getName());
    private Destination destination;
    private MessageObserver messageObserver;
    private Endpoint endpoint;
    private ServerRegistry serverRegistry;

    public ServerImpl(Bus bus, Endpoint endpoint, MessageObserver observer) throws BusException, IOException {
        this.endpoint = endpoint;
        this.messageObserver = observer;
        EndpointInfo ei = endpoint.getEndpointInfo();
        DestinationFactory destinationFactory = ((DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class)).getDestinationFactory(ei.getTransportId());
        this.destination = destinationFactory.getDestination(ei);
        this.serverRegistry = (ServerRegistry)bus.getExtension(ServerRegistry.class);
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public void start() {
        this.getDestination().setMessageObserver(this.messageObserver);
        if (null != this.serverRegistry) {
            LOG.fine("register the server to serverRegistry ");
            this.serverRegistry.register((Server)this);
        }
    }

    public void stop() {
        LOG.fine("Server is stopping.");
        this.getDestination().setMessageObserver(null);
    }

    public MessageObserver getMessageObserver() {
        return this.messageObserver;
    }

    public void setMessageObserver(MessageObserver messageObserver) {
        this.messageObserver = messageObserver;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }
}

