/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.IOException;
import java.util.ResourceBundle;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.Conduit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageSenderInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(MessageSenderInterceptor.class);

    public MessageSenderInterceptor() {
        this.setPhase("prepare-send");
    }

    public void handleMessage(Message message) {
        Exchange exchange = message.getExchange();
        Conduit conduit = message.getConduit() != null ? message.getConduit() : (exchange.getConduit() != null ? exchange.getConduit() : (exchange.getOutMessage() != null ? OutgoingChainInterceptor.getBackChannelConduit(exchange) : null));
        try {
            conduit.send(message);
            if (message.getInterceptorChain().doIntercept(message)) {
                conduit.close(message);
            } else if (message.getContent(Exception.class) != null) {
                if (message.getContent(Exception.class) instanceof Fault) {
                    throw (Fault)message.getContent(Exception.class);
                }
                throw new Fault((Throwable)message.getContent(Exception.class));
            }
        }
        catch (IOException ex) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("COULD_NOT_SEND", BUNDLE, new Object[0]), (Throwable)ex);
        }
    }
}

