/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutgoingChainSetupInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = Logger.getLogger(OutgoingChainSetupInterceptor.class.getName());

    public OutgoingChainSetupInterceptor() {
        this.setPhase("pre-logical");
    }

    public void handleMessage(Message message) {
        Exchange ex = message.getExchange();
        if (ex.isOneWay()) {
            return;
        }
        Endpoint ep = (Endpoint)ex.get(Endpoint.class);
        Message outMessage = message.getExchange().getOutMessage();
        if (outMessage == null) {
            outMessage = ep.getBinding().createMessage();
            ex.setOutMessage(outMessage);
        }
        this.setUpContentType(outMessage);
        Message faultMessage = message.getExchange().getOutFaultMessage();
        if (faultMessage == null) {
            faultMessage = ep.getBinding().createMessage();
            ex.setOutFaultMessage(faultMessage);
        }
        this.setUpContentType(faultMessage);
        outMessage.setInterceptorChain(OutgoingChainSetupInterceptor.getOutInterceptorChain(ex));
    }

    private void setUpContentType(Message message) {
        if (StringUtils.isEmpty((String)((String)message.get((Object)Message.CONTENT_TYPE)))) {
            return;
        }
        HashMap<String, List<String>> headers = (HashMap<String, List<String>>)message.get((Object)Message.PROTOCOL_HEADERS);
        if (headers == null) {
            headers = new HashMap<String, List<String>>();
            message.put((Object)Message.PROTOCOL_HEADERS, headers);
        }
        LOG.info("OutgoingChainSetupInterceptor set the content-type to: " + message.get((Object)Message.CONTENT_TYPE));
        headers.put("Content-Type", Arrays.asList((String)message.get((Object)Message.CONTENT_TYPE)));
    }

    public static InterceptorChain getOutInterceptorChain(Exchange ex) {
        Bus bus = (Bus)ex.get(Bus.class);
        PhaseManager pm = (PhaseManager)bus.getExtension(PhaseManager.class);
        PhaseInterceptorChain chain = new PhaseInterceptorChain(pm.getOutPhases());
        Endpoint ep = (Endpoint)ex.get(Endpoint.class);
        List il = ep.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by endpoint: " + il);
        }
        chain.add(il);
        il = ep.getService().getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by service: " + il);
        }
        chain.add(il);
        il = bus.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + il);
        }
        chain.add(il);
        if (ep.getBinding() != null) {
            il = ep.getBinding().getOutInterceptors();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Interceptors contributed by binding: " + il);
            }
            chain.add(il);
        }
        chain.setFaultObserver(ep.getOutFaultObserver());
        return chain;
    }
}

