/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceInvokerInterceptor
extends AbstractPhaseInterceptor<Message> {
    public ServiceInvokerInterceptor() {
        this.setPhase("invoke");
    }

    public void handleMessage(final Message message) {
        final Exchange exchange = message.getExchange();
        Endpoint endpoint = (Endpoint)exchange.get(Endpoint.class);
        Service service = endpoint.getService();
        final Invoker invoker = service.getInvoker();
        this.getExecutor(endpoint).execute(new Runnable(){

            public void run() {
                List<Object> result = invoker.invoke(message.getExchange(), ServiceInvokerInterceptor.this.getInvokee(message));
                if (result != null) {
                    if (result instanceof List) {
                        exchange.getOutMessage().setContent(List.class, (Object)result);
                    } else if (result.getClass().isArray()) {
                        result = Arrays.asList((Object[])result);
                        exchange.getOutMessage().setContent(List.class, result);
                    } else {
                        exchange.getOutMessage().setContent(Object.class, result);
                    }
                }
            }
        });
    }

    private Object getInvokee(Message message) {
        Object invokee = message.getContent(List.class);
        if (invokee == null) {
            invokee = message.getContent(Object.class);
        }
        return invokee;
    }

    private Executor getExecutor(Endpoint endpoint) {
        return endpoint.getService().getExecutor();
    }
}

