/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport;

import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.transport.MessageObserver;

public class ChainInitiationObserver
implements MessageObserver {
    protected Endpoint endpoint;
    protected Bus bus;

    public ChainInitiationObserver(Endpoint endpoint, Bus bus) {
        this.endpoint = endpoint;
        this.bus = bus;
    }

    public void onMessage(Message m) {
        Message message = this.endpoint.getBinding().createMessage(m);
        Exchange exchange = message.getExchange();
        if (exchange == null) {
            exchange = new ExchangeImpl();
            exchange.setInMessage(message);
        }
        this.setExchangeProperties(exchange, message);
        PhaseInterceptorChain chain = new PhaseInterceptorChain(((PhaseManager)this.bus.getExtension(PhaseManager.class)).getInPhases());
        message.setInterceptorChain((InterceptorChain)chain);
        chain.add(this.bus.getInInterceptors());
        chain.add(this.endpoint.getInInterceptors());
        chain.add(this.endpoint.getBinding().getInInterceptors());
        chain.add(this.endpoint.getService().getInInterceptors());
        chain.setFaultObserver(this.endpoint.getOutFaultObserver());
        chain.doIntercept(message);
    }

    protected void setExchangeProperties(Exchange exchange, Message m) {
        exchange.put(Endpoint.class, (Object)this.endpoint);
        exchange.put(Service.class, (Object)this.endpoint.getService());
        exchange.put(Binding.class, (Object)this.endpoint.getBinding());
        exchange.put(Bus.class, (Object)this.bus);
        exchange.setDestination(m.getDestination());
    }
}

