/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.local;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import org.apache.cxf.binding.attachment.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.local.LocalDestination;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class LocalConduit
implements Conduit {
    public static final String IN_CONDUIT = LocalConduit.class.getName() + ".inConduit";
    public static final String IN_EXCHANGE = LocalConduit.class.getName() + ".inExchange";
    private LocalDestination destination;
    private MessageObserver observer;

    public LocalConduit(LocalDestination destination) {
        this.destination = destination;
    }

    public void close(Message msg) throws IOException {
        ((OutputStream)msg.getContent(OutputStream.class)).close();
    }

    public void close() {
    }

    public Destination getBackChannel() {
        return null;
    }

    public EndpointReferenceType getTarget() {
        return this.destination.getAddress();
    }

    public void send(Message message) throws IOException {
        final PipedInputStream stream = new PipedInputStream();
        final LocalConduit conduit = this;
        final Exchange exchange = message.getExchange();
        if (this.destination.getMessageObserver() == null) {
            throw new IllegalStateException("Local destination does not have a MessageObserver on address " + this.destination.getAddress().getAddress().getValue());
        }
        Runnable receiver = new Runnable(){

            public void run() {
                MessageImpl m = new MessageImpl();
                m.setContent(InputStream.class, (Object)stream);
                m.setDestination((Destination)LocalConduit.this.destination);
                m.put((Object)IN_CONDUIT, (Object)conduit);
                ExchangeImpl ex = new ExchangeImpl();
                ex.setInMessage((Message)m);
                ex.put((Object)IN_EXCHANGE, (Object)exchange);
                LocalConduit.this.destination.getMessageObserver().onMessage((Message)m);
            }
        };
        CachedOutputStream outStream = new CachedOutputStream(stream);
        message.setContent(OutputStream.class, (Object)outStream);
        new Thread(receiver).start();
    }

    public void setMessageObserver(MessageObserver o) {
        this.observer = o;
    }

    public MessageObserver getMessageObserver() {
        return this.observer;
    }
}

