/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.local;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.local.LocalConduit;
import org.apache.cxf.transport.local.LocalTransportFactory;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class LocalDestination
implements Destination {
    private LocalTransportFactory localDestinationFactory;
    private MessageObserver messageObserver;
    private EndpointReferenceType epr;

    public LocalDestination(LocalTransportFactory localDestinationFactory, EndpointReferenceType epr) {
        this.localDestinationFactory = localDestinationFactory;
        this.epr = epr;
    }

    public EndpointReferenceType getAddress() {
        return this.epr;
    }

    public Conduit getBackChannel(Message inMessage, Message partialResponse, EndpointReferenceType address) {
        Conduit conduit = (Conduit)inMessage.get((Object)LocalConduit.IN_CONDUIT);
        if (conduit instanceof LocalConduit) {
            return new SynchronousConduit((LocalConduit)conduit);
        }
        return null;
    }

    public void shutdown() {
        this.localDestinationFactory.remove(this);
    }

    public void setMessageObserver(MessageObserver observer) {
        this.messageObserver = observer;
    }

    public MessageObserver getMessageObserver() {
        return this.messageObserver;
    }

    static class SynchronousConduit
    implements Conduit {
        private LocalConduit conduit;

        public SynchronousConduit(LocalConduit conduit) {
            this.conduit = conduit;
        }

        public void close(Message msg) throws IOException {
            ((OutputStream)msg.getContent(OutputStream.class)).close();
        }

        public void close() {
        }

        public Destination getBackChannel() {
            return null;
        }

        public EndpointReferenceType getTarget() {
            return null;
        }

        public void send(Message message) throws IOException {
            final PipedInputStream stream = new PipedInputStream();
            final Exchange exchange = (Exchange)message.getExchange().get((Object)LocalConduit.IN_EXCHANGE);
            Runnable receiver = new Runnable(){

                public void run() {
                    MessageImpl m = new MessageImpl();
                    if (exchange != null) {
                        exchange.setInMessage((Message)m);
                    }
                    m.setContent(InputStream.class, (Object)stream);
                    SynchronousConduit.this.conduit.getMessageObserver().onMessage((Message)m);
                }
            };
            PipedOutputStream outStream = new PipedOutputStream(stream);
            message.setContent(OutputStream.class, (Object)outStream);
            new Thread(receiver).start();
        }

        public void setMessageObserver(MessageObserver observer) {
        }
    }
}

