/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.xml.XMLBindingInfoFactoryBean;
import org.apache.cxf.common.injection.ResourceInjector;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.jaxws.JAXWSMethodInvoker;
import org.apache.cxf.jaxws.ProviderChainObserver;
import org.apache.cxf.jaxws.ProviderInvoker;
import org.apache.cxf.jaxws.binding.soap.JaxWsSoapBindingInfoFactoryBean;
import org.apache.cxf.jaxws.context.WebContextResourceResolver;
import org.apache.cxf.jaxws.handler.AnnotationHandlerChainBuilder;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.jaxws.support.ProviderServiceFactoryBean;
import org.apache.cxf.message.Message;
import org.apache.cxf.resource.DefaultResourceManager;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.AbstractBindingInfoFactoryBean;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServerFactoryBean;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.transport.MessageObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointImpl
extends javax.xml.ws.Endpoint {
    private static final Logger LOG = LogUtils.getL7dLogger(JaxWsServiceFactoryBean.class);
    protected boolean doInit;
    private Bus bus;
    private Object implementor;
    private Server server;
    private Service service;
    private JaxWsImplementorInfo implInfo;
    private ReflectionServiceFactoryBean serviceFactory;
    private String bindingURI;

    public EndpointImpl(Bus b, Object implementor, JaxWsServiceFactoryBean serviceFactory) {
        this.bus = b;
        this.serviceFactory = serviceFactory;
        this.implInfo = serviceFactory.getJaxWsImplementorInfo();
        this.service = serviceFactory.getService();
        this.implementor = implementor;
        if (this.service == null) {
            this.service = serviceFactory.create();
        }
        this.doInit = true;
    }

    public EndpointImpl(Bus b, Object i, String uri) {
        this.bus = b;
        this.implementor = i;
        this.bindingURI = uri;
        this.implInfo = new JaxWsImplementorInfo(this.implementor.getClass());
        this.serviceFactory = this.implInfo.isWebServiceProvider() ? new ProviderServiceFactoryBean(this.implInfo) : new JaxWsServiceFactoryBean(this.implInfo);
        this.serviceFactory.setBus(this.bus);
        this.service = this.serviceFactory.create();
        this.configureObject(this.service);
        this.service.put((Object)Message.SCHEMA_VALIDATION_ENABLED, (Object)this.service.getEnableSchemaValidationForAllPort());
        if (this.implInfo.isWebServiceProvider()) {
            this.service.setInvoker(new ProviderInvoker((Provider)i));
        } else {
            this.service.setInvoker((Invoker)new JAXWSMethodInvoker(i));
        }
        this.doInit = true;
    }

    public Binding getBinding() {
        return ((JaxWsEndpointImpl)this.getEndpoint()).getJaxwsBinding();
    }

    public void setExecutor(Executor executor) {
        this.service.setExecutor(executor);
    }

    public Executor getExecutor() {
        return this.service.getExecutor();
    }

    public Object getImplementor() {
        return this.implementor;
    }

    public List<Source> getMetadata() {
        return null;
    }

    public Map<String, Object> getProperties() {
        return null;
    }

    public boolean isPublished() {
        return this.server != null;
    }

    public void publish(Object arg0) {
    }

    public void publish(String address) {
        this.doPublish(address);
    }

    public void setMetadata(List<Source> arg0) {
    }

    public void setProperties(Map<String, Object> arg0) {
    }

    public void stop() {
        if (null != this.server) {
            this.server.stop();
        }
    }

    public ServerImpl getServer() {
        return (ServerImpl)this.server;
    }

    protected void injectResources(Object instance) {
        if (instance != null) {
            ResourceManager resourceManager = (ResourceManager)this.bus.getExtension(ResourceManager.class);
            List resolvers = resourceManager.getResourceResolvers();
            resourceManager = new DefaultResourceManager(resolvers);
            resourceManager.addResourceResolver((ResourceResolver)new WebContextResourceResolver());
            ResourceInjector injector = new ResourceInjector(resourceManager);
            injector.inject(instance);
        }
    }

    protected void doPublish(String address) {
        ServerFactoryBean svrFactory = new ServerFactoryBean();
        svrFactory.setBus(this.bus);
        svrFactory.setAddress(address);
        svrFactory.setServiceFactory(this.serviceFactory);
        svrFactory.setStart(false);
        this.configureObject(svrFactory);
        Object bindingFactory = null;
        bindingFactory = "http://cxf.apache.org/bindings/xformat".equals(this.bindingURI) ? new XMLBindingInfoFactoryBean() : new JaxWsSoapBindingInfoFactoryBean();
        svrFactory.setBindingFactory((AbstractBindingInfoFactoryBean)bindingFactory);
        this.server = svrFactory.create();
        this.init();
        if (this.implInfo.isWebServiceProvider()) {
            this.getServer().setMessageObserver((MessageObserver)new ProviderChainObserver(this.getEndpoint(), this.bus, this.implInfo));
        }
        Endpoint endpoint = this.getEndpoint();
        this.configureObject(endpoint);
        if (endpoint.getEnableSchemaValidation()) {
            endpoint.put((Object)Message.SCHEMA_VALIDATION_ENABLED, (Object)endpoint.getEnableSchemaValidation());
        }
        this.server.start();
    }

    Endpoint getEndpoint() {
        return this.getServer().getEndpoint();
    }

    private void configureObject(Object instance) {
        Configurer configurer = (Configurer)this.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(instance);
        }
    }

    private synchronized void init() {
        if (this.doInit) {
            try {
                this.injectResources(this.implementor);
                this.configureHandlers();
            }
            catch (Exception ex) {
                if (ex instanceof WebServiceException) {
                    throw (WebServiceException)ex;
                }
                throw new WebServiceException("Creation of Endpoint failed", (Throwable)ex);
            }
        }
        this.doInit = false;
    }

    private void configureHandlers() {
        LOG.fine("loading handler chain for endpoint");
        AnnotationHandlerChainBuilder builder = new AnnotationHandlerChainBuilder();
        List<Handler> chain = null;
        if (null == chain || chain.size() == 0) {
            chain = builder.buildHandlerChainFromClass(this.implementor.getClass());
        }
        this.getBinding().setHandlerChain(chain);
    }
}

