/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.ws.Holder;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.binding.soap.model.SoapHeaderInfo;
import org.apache.cxf.common.util.factory.Factory;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.apache.cxf.jaxws.support.ContextPropertiesMapping;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.service.invoker.ApplicationScopePolicy;
import org.apache.cxf.service.invoker.FactoryInvoker;
import org.apache.cxf.service.invoker.ScopePolicy;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSMethodInvoker
extends FactoryInvoker {
    public JAXWSMethodInvoker(final Object bean) {
        super(new Factory(){

            public Object create() {
                return bean;
            }
        }, ApplicationScopePolicy.instance());
    }

    public JAXWSMethodInvoker(Factory factory) {
        super(factory, ApplicationScopePolicy.instance());
    }

    public JAXWSMethodInvoker(Factory factory, ScopePolicy scope) {
        super(factory, scope);
    }

    protected Object invoke(Exchange exchange, Object serviceObject, Method m, List<Object> params) {
        BindingOperationInfo bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        List<Object> orderedParams = params;
        if (bop != null && bop.getInput() != null) {
            orderedParams = this.getOrderedParamList(params, bop.getInput());
        }
        this.checkHolder(m, orderedParams, exchange);
        MessageContext ctx = ContextPropertiesMapping.createWebServiceContext(exchange);
        WebServiceContextImpl.setMessageContext(ctx);
        List res = (List)super.invoke(exchange, serviceObject, m, orderedParams);
        if (bop != null && bop.getOutput() != null) {
            this.getOrderedReturnList(res, orderedParams, bop.getOutput());
        } else {
            for (Object o : orderedParams) {
                if (!(o instanceof Holder)) continue;
                res.add(((Holder)o).value);
            }
        }
        ContextPropertiesMapping.updateWebServiceContext(exchange, ctx);
        return res;
    }

    private void checkHolder(Method method, List<Object> params, Exchange exchange) {
        if (method != null) {
            Type[] para = method.getGenericParameterTypes();
            for (int i = 0; i < para.length; ++i) {
                ParameterizedType paramType;
                if (!(para[i] instanceof ParameterizedType) || !((Class)(paramType = (ParameterizedType)para[i]).getRawType()).getName().equals("javax.xml.ws.Holder")) continue;
                if (i >= params.size()) {
                    params.add(new Holder());
                    continue;
                }
                params.set(i, new Holder(params.get(i)));
            }
        }
    }

    private List<Object> getOrderedParamList(List<Object> params, BindingMessageInfo bmi) {
        List headers = bmi.getExtensors(SoapHeaderInfo.class);
        if (headers == null || headers.isEmpty()) {
            return params;
        }
        ArrayList<Object> orderedParams = new ArrayList<Object>();
        int headerIdx = params.size() - headers.size();
        orderedParams.addAll(params.subList(0, headerIdx));
        TreeMap<Integer, Object> headerParams = new TreeMap<Integer, Object>();
        for (SoapHeaderInfo header : headers) {
            headerParams.put(header.getSequence(), params.get(headerIdx));
            ++headerIdx;
        }
        for (Integer i : headerParams.keySet()) {
            if (i <= orderedParams.size()) {
                orderedParams.add(i, headerParams.get(i));
                continue;
            }
            orderedParams.add(headerParams.get(i));
        }
        return orderedParams;
    }

    private void getOrderedReturnList(List<Object> res, List<Object> params, BindingMessageInfo bmi) {
        List headers = bmi.getExtensors(SoapHeaderInfo.class);
        int returnIdx = 0;
        if (headers != null && !headers.isEmpty()) {
            Integer i;
            TreeSet<Integer> headerIndices = new TreeSet<Integer>();
            for (SoapHeaderInfo header : headers) {
                headerIndices.add(header.getSequence());
            }
            Iterator i$ = headerIndices.iterator();
            while (i$.hasNext() && (i = (Integer)i$.next()) <= returnIdx && params.get(i) instanceof Holder) {
                res.add(i, ((Holder)params.get((int)i.intValue())).value);
                ++returnIdx;
            }
        }
        for (int i = returnIdx; i < params.size(); ++i) {
            Object o = params.get(i);
            if (!(o instanceof Holder)) continue;
            res.add(((Holder)o).value);
        }
    }
}

