/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.spi.ServiceDelegate;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.xml.XMLBindingInfoFactoryBean;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.DispatchImpl;
import org.apache.cxf.jaxws.EndpointInvocationHandler;
import org.apache.cxf.jaxws.binding.soap.JaxWsSoapBindingInfoFactoryBean;
import org.apache.cxf.jaxws.handler.HandlerResolverImpl;
import org.apache.cxf.jaxws.support.DummyImpl;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.AbstractServiceFactoryBean;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.wsdl11.WSDLServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceImpl
extends ServiceDelegate {
    private static final Logger LOG = LogUtils.getL7dLogger(ServiceImpl.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();
    private Bus bus;
    private URL wsdlURL;
    private HandlerResolver handlerResolver;
    private final Collection<QName> ports = new HashSet<QName>();
    private Map<QName, PortInfo> portInfos = new HashMap<QName, PortInfo>();
    private Executor executor;
    private QName serviceName;

    public ServiceImpl(Bus b, URL url, QName name, Class<?> cls) {
        this.bus = b;
        this.wsdlURL = url;
        this.serviceName = name;
        this.handlerResolver = new HandlerResolverImpl(this.bus, name);
    }

    public void addPort(QName portName, String bindingId, String address) {
        PortInfo portInfo = new PortInfo(bindingId, address);
        this.portInfos.put(portName, portInfo);
    }

    private Endpoint getJaxwsEndpoint(QName portName, AbstractServiceFactoryBean sf) {
        Service service = sf.getService();
        ServiceInfo si = service.getServiceInfo();
        EndpointInfo ei = null;
        if (portName == null) {
            ei = (EndpointInfo)si.getEndpoints().iterator().next();
        } else {
            PortInfo portInfo = this.getPortInfo(portName);
            if (null != portInfo) {
                try {
                    ei = this.createEndpointInfo(sf, portName, portInfo);
                }
                catch (BusException e) {
                    throw new WebServiceException((Throwable)e);
                }
            } else {
                ei = si.getEndpoint(portName);
            }
        }
        try {
            return new JaxWsEndpointImpl(this.bus, service, ei);
        }
        catch (EndpointException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private AbstractServiceFactoryBean createDispatchService() {
        try {
            return this.createDispatchService(new JAXBDataBinding(new Class[0]));
        }
        catch (JAXBException e) {
            throw new WebServiceException("Could not create Databinding.", (Throwable)e);
        }
    }

    private AbstractServiceFactoryBean createDispatchService(JAXBContext context) {
        return this.createDispatchService(new JAXBDataBinding(context));
    }

    private AbstractServiceFactoryBean createDispatchService(JAXBDataBinding db) {
        Object serviceFactory;
        Service dispatchService = null;
        if (null != this.wsdlURL) {
            WSDLServiceFactory sf = new WSDLServiceFactory(this.bus, this.wsdlURL, this.serviceName);
            dispatchService = sf.create();
            dispatchService.setDataBinding((DataBinding)db);
            serviceFactory = sf;
        } else {
            JaxWsServiceFactoryBean sf = new JaxWsServiceFactoryBean();
            sf.setBus(this.bus);
            sf.setServiceName(this.serviceName);
            sf.setServiceClass(DummyImpl.class);
            sf.setDataBinding((DataBinding)db);
            dispatchService = sf.create();
            serviceFactory = sf;
        }
        this.configureObject(dispatchService);
        return serviceFactory;
    }

    public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, Service.Mode mode) {
        AbstractServiceFactoryBean sf = this.createDispatchService();
        Endpoint endpoint = this.getJaxwsEndpoint(portName, sf);
        DispatchImpl<T> disp = new DispatchImpl<T>(this.bus, mode, type, this.getExecutor(), endpoint);
        this.configureObject(disp);
        return disp;
    }

    public Dispatch<Object> createDispatch(QName portName, JAXBContext context, Service.Mode mode) {
        AbstractServiceFactoryBean sf = this.createDispatchService(context);
        Endpoint endpoint = this.getJaxwsEndpoint(portName, sf);
        DispatchImpl<Object> disp = new DispatchImpl<Object>(this.bus, mode, context, Object.class, this.getExecutor(), endpoint);
        this.configureObject(disp);
        return disp;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public HandlerResolver getHandlerResolver() {
        return this.handlerResolver;
    }

    public <T> T getPort(Class<T> type) {
        return this.createPort(null, type);
    }

    public <T> T getPort(QName portName, Class<T> type) {
        if (portName == null) {
            throw new WebServiceException(BUNDLE.getString("PORT_NAME_NULL_EXC"));
        }
        return this.createPort(portName, type);
    }

    public Iterator<QName> getPorts() {
        return this.ports.iterator();
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public URL getWSDLDocumentLocation() {
        return this.wsdlURL;
    }

    public void setExecutor(Executor e) {
        this.executor = e;
    }

    public void setHandlerResolver(HandlerResolver hr) {
        this.handlerResolver = hr;
    }

    public Bus getBus() {
        return this.bus;
    }

    protected <T> T createPort(QName portName, Class<T> serviceEndpointInterface) {
        JaxWsEndpointImpl jaxwsEndpoint;
        LOG.log(Level.FINE, "creating port for portName", portName);
        LOG.log(Level.FINE, "endpoint interface:", serviceEndpointInterface);
        JaxWsServiceFactoryBean serviceFactory = new JaxWsServiceFactoryBean();
        serviceFactory.setBus(this.bus);
        serviceFactory.setServiceName(this.serviceName);
        serviceFactory.setServiceClass(serviceEndpointInterface);
        if (this.wsdlURL != null) {
            serviceFactory.setWsdlURL(this.wsdlURL);
        }
        Service service = serviceFactory.create();
        this.configureObject(service);
        service.put((Object)Message.SCHEMA_VALIDATION_ENABLED, (Object)service.getEnableSchemaValidationForAllPort());
        QName pn = portName;
        ServiceInfo si = service.getServiceInfo();
        EndpointInfo ei = null;
        if (portName == null) {
            if (1 == si.getEndpoints().size()) {
                ei = (EndpointInfo)si.getEndpoints().iterator().next();
                pn = new QName(service.getName().getNamespaceURI(), ei.getName().getLocalPart());
            }
        } else {
            PortInfo portInfo = this.portInfos.get(portName);
            if (null != portInfo) {
                try {
                    ei = this.createEndpointInfo((AbstractServiceFactoryBean)serviceFactory, portName, portInfo);
                }
                catch (BusException e) {
                    throw new WebServiceException((Throwable)e);
                }
            } else {
                ei = si.getEndpoint(portName);
            }
        }
        if (null == pn) {
            throw new WebServiceException(BUNDLE.getString("COULD_NOT_DETERMINE_PORT"));
        }
        try {
            jaxwsEndpoint = new JaxWsEndpointImpl(this.bus, service, ei);
        }
        catch (EndpointException e) {
            throw new WebServiceException((Throwable)e);
        }
        this.configureObject((Object)jaxwsEndpoint);
        if (jaxwsEndpoint.getEnableSchemaValidation()) {
            jaxwsEndpoint.put(Message.SCHEMA_VALIDATION_ENABLED, jaxwsEndpoint.getEnableSchemaValidation());
        }
        ClientImpl client = new ClientImpl(this.bus, (Endpoint)jaxwsEndpoint);
        EndpointInvocationHandler ih = new EndpointInvocationHandler((Client)client, jaxwsEndpoint.getJaxwsBinding());
        Object obj = Proxy.newProxyInstance(serviceEndpointInterface.getClassLoader(), new Class[]{serviceEndpointInterface, BindingProvider.class}, (InvocationHandler)ih);
        LOG.log(Level.FINE, "created proxy", obj);
        this.ports.add(pn);
        return serviceEndpointInterface.cast(obj);
    }

    private EndpointInfo createEndpointInfo(AbstractServiceFactoryBean serviceFactory, QName portName, PortInfo portInfo) throws BusException {
        EndpointInfo ei = null;
        String address = portInfo.getAddress();
        DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
        DestinationFactory df = dfm.getDestinationFactoryForUri(portInfo.getAddress());
        String transportId = (String)df.getTransportIds().get(0);
        String bindingUri = portInfo.getBindingUri();
        Object bindingFactory = null;
        if (bindingUri.equals("http://cxf.apache.org/bindings/xformat")) {
            bindingFactory = new XMLBindingInfoFactoryBean();
        } else if ("http://schemas.xmlsoap.org/soap/".equals(bindingUri)) {
            JaxWsSoapBindingInfoFactoryBean soapBindingFactory = new JaxWsSoapBindingInfoFactoryBean();
            soapBindingFactory.setTransportURI(transportId);
            bindingFactory = soapBindingFactory;
        } else {
            bindingFactory = new XMLBindingInfoFactoryBean();
        }
        bindingFactory.setServiceFactory(serviceFactory);
        BindingInfo bindingInfo = bindingFactory.create();
        Service service = serviceFactory.getService();
        service.getServiceInfo().addBinding(bindingInfo);
        ei = new EndpointInfo(service.getServiceInfo(), transportId);
        ei.setName(portName);
        ei.setAddress(address);
        ei.setBinding(bindingInfo);
        service.getServiceInfo().addEndpoint(ei);
        return ei;
    }

    private void configureObject(Object instance) {
        Configurer configurer = (Configurer)this.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(instance);
        }
    }

    private PortInfo getPortInfo(QName portName) {
        return this.portInfos.get(portName);
    }

    static class PortInfo {
        private String bindingUri;
        private String address;

        public PortInfo(String bindingUri, String address2) {
            this.bindingUri = bindingUri;
            this.address = address2;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public String getBindingUri() {
            return this.bindingUri;
        }

        public void setBindingUri(String bindingUri) {
            this.bindingUri = bindingUri;
        }
    }
}

