/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.HandlerChain;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxws.handler.HandlerChainBuilder;
import org.apache.cxf.jaxws.javaee.HandlerChainType;
import org.apache.cxf.jaxws.javaee.HandlerChainsType;
import org.apache.cxf.jaxws.javaee.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHandlerChainBuilder
extends HandlerChainBuilder {
    private static final Logger LOG = LogUtils.getL7dLogger(AnnotationHandlerChainBuilder.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();

    public AnnotationHandlerChainBuilder() {
    }

    public AnnotationHandlerChainBuilder(Bus bus) {
        super(bus);
    }

    public List<Handler> buildHandlerChainFromClass(Class<?> clz, List<Handler> existingHandlers) {
        LOG.fine("building handler chain");
        HandlerChainAnnotation hcAnn = this.findHandlerChainAnnotation(clz);
        List<Handler> chain = null;
        if (hcAnn == null) {
            LOG.fine("no HandlerChain annotation on " + clz);
            chain = new ArrayList<Handler>();
        } else {
            hcAnn.validate();
            HandlerChainType hc = null;
            try {
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
                Unmarshaller u = jc.createUnmarshaller();
                URL handlerFileURL = clz.getResource(hcAnn.getFileName());
                JAXBElement o = (JAXBElement)u.unmarshal(handlerFileURL);
                HandlerChainsType handlerChainsType = (HandlerChainsType)o.getValue();
                if (null == handlerChainsType || handlerChainsType.getHandlerChain().size() == 0) {
                    throw new WebServiceException(BUNDLE.getString("CHAIN_NOT_SPECIFIED_EXC"));
                }
                hc = handlerChainsType.getHandlerChain().iterator().next();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new WebServiceException(BUNDLE.getString("CHAIN_NOT_SPECIFIED_EXC"), (Throwable)e);
            }
            chain = this.buildHandlerChain(hc, clz.getClassLoader());
        }
        assert (chain != null);
        if (existingHandlers != null) {
            chain.addAll(existingHandlers);
        }
        return this.sortHandlers(chain);
    }

    public List<Handler> buildHandlerChainFromClass(Class<?> clz) {
        return this.buildHandlerChainFromClass(clz, null);
    }

    private HandlerChainAnnotation findHandlerChainAnnotation(Class<?> clz) {
        HandlerChain ann = clz.getAnnotation(HandlerChain.class);
        Class<?> declaringClass = clz;
        if (ann == null) {
            for (Class<?> iface : clz.getInterfaces()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("checking for HandlerChain annotation on " + iface.getName());
                }
                if ((ann = iface.getAnnotation(HandlerChain.class)) == null) continue;
                declaringClass = iface;
                break;
            }
        }
        if (ann != null) {
            return new HandlerChainAnnotation(ann, declaringClass);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HandlerChainAnnotation {
        private final Class<?> declaringClass;
        private final HandlerChain ann;

        HandlerChainAnnotation(HandlerChain hc, Class<?> clz) {
            this.ann = hc;
            this.declaringClass = clz;
        }

        public Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        public String getFileName() {
            return this.ann.file();
        }

        public String getChainName() {
            return this.ann.name();
        }

        public void validate() {
            if (null == this.ann.file() || "".equals(this.ann.file())) {
                throw new WebServiceException(BUNDLE.getString("ANNOTATION_WITHOUT_URL_EXC"));
            }
            if (null == this.ann.name() || "".equals(this.ann.name())) {
                LOG.fine("no handler name specified, defaulting to first declared");
            }
        }

        public String toString() {
            return "[" + this.declaringClass + "," + this.ann + "]";
        }
    }
}

