/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler.soap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.AbstractCachedOutputStream;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPMessageContextImpl
extends WrappedMessageContext
implements SOAPMessageContext {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(SOAPMessageContextImpl.class);

    SOAPMessageContextImpl(Message m) {
        super(m);
    }

    public void setMessage(SOAPMessage message) {
        this.getWrappedMessage().setContent(SOAPMessage.class, (Object)message);
    }

    public SOAPMessage getMessage() {
        SOAPMessage message = (SOAPMessage)this.getWrappedMessage().getContent(SOAPMessage.class);
        if (null == message) {
            try {
                Boolean outboundProperty = (Boolean)this.get("javax.xml.ws.handler.message.outbound");
                if (outboundProperty.booleanValue()) {
                    MessageFactory factory = MessageFactory.newInstance();
                    MimeHeaders mhs = null;
                    AbstractCachedOutputStream out = (AbstractCachedOutputStream)this.getWrappedMessage().getContent(OutputStream.class);
                    InputStream is = out.getInputStream();
                    message = factory.createMessage(mhs, is);
                } else {
                    CachedStream cs = new CachedStream();
                    XMLStreamWriter writer = StaxUtils.getXMLOutputFactory().createXMLStreamWriter((OutputStream)((Object)cs));
                    XMLStreamReader xmlReader = (XMLStreamReader)this.getWrappedMessage().getContent(XMLStreamReader.class);
                    Soap11 soapVersion = Soap11.getInstance();
                    writer.setPrefix(soapVersion.getPrefix(), soapVersion.getNamespace());
                    writer.writeStartElement(soapVersion.getPrefix(), soapVersion.getEnvelope().getLocalPart(), soapVersion.getNamespace());
                    writer.writeNamespace(soapVersion.getPrefix(), soapVersion.getNamespace());
                    if (this.getWrappedSoapMessage().hasHeaders(Element.class)) {
                        Element headerElements = (Element)this.getWrappedSoapMessage().getHeaders(Element.class);
                        StaxUtils.writeElement((Element)headerElements, (XMLStreamWriter)writer, (boolean)true);
                    }
                    writer.writeStartElement(soapVersion.getPrefix(), soapVersion.getBody().getLocalPart(), soapVersion.getNamespace());
                    StaxUtils.copy((XMLStreamReader)xmlReader, (XMLStreamWriter)writer);
                    xmlReader.close();
                    writer.close();
                    cs.doFlush();
                    InputStream newIs = cs.getInputStream();
                    MessageFactory factory = MessageFactory.newInstance();
                    MimeHeaders mhs = null;
                    message = factory.createMessage(mhs, newIs);
                }
                this.getWrappedMessage().setContent(SOAPMessage.class, (Object)message);
            }
            catch (IOException ioe) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("SOAPHANDLERINTERCEPTOR_EXCEPTION", BUNDLE, new Object[0]), (Throwable)ioe);
            }
            catch (SOAPException soape) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("SOAPHANDLERINTERCEPTOR_EXCEPTION", BUNDLE, new Object[0]), (Throwable)soape);
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
                throw new Fault(new org.apache.cxf.common.i18n.Message("SOAPHANDLERINTERCEPTOR_EXCEPTION", BUNDLE, new Object[0]), (Throwable)e);
            }
        }
        return message;
    }

    public Object[] getHeaders(QName name, JAXBContext context, boolean allRoles) {
        Element headerElements = (Element)this.getWrappedSoapMessage().getHeaders(Element.class);
        if (headerElements == null) {
            return null;
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        for (int i = 0; i < headerElements.getChildNodes().getLength(); ++i) {
            Element e;
            if (!(headerElements.getChildNodes().item(i) instanceof Element) || !name.equals((e = (Element)headerElements.getChildNodes().item(i)).getNamespaceURI())) continue;
            try {
                objects.add(context.createUnmarshaller().unmarshal((Node)e));
                continue;
            }
            catch (JAXBException ex) {
                // empty catch block
            }
        }
        Object[] headerObjects = new Object[objects.size()];
        return objects.toArray(headerObjects);
    }

    public Set<String> getRoles() {
        return null;
    }

    private SoapMessage getWrappedSoapMessage() {
        return (SoapMessage)this.getWrappedMessage();
    }

    private class CachedStream
    extends AbstractCachedOutputStream {
        private CachedStream() {
        }

        protected void doFlush() throws IOException {
            this.currentStream.flush();
        }

        protected void doClose() throws IOException {
            this.currentStream.close();
        }

        protected void onWrite() throws IOException {
        }
    }
}

