/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Service;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.XMLMessage;

public class DispatchOutInterceptor
extends AbstractOutDatabindingInterceptor {
    public DispatchOutInterceptor() {
        this.setPhase("write");
    }

    public void handleMessage(Message message) throws Fault {
        Service.Mode m = (Service.Mode)message.getExchange().get(Service.Mode.class);
        try {
            OutputStream os = (OutputStream)message.getContent(OutputStream.class);
            Object obj = message.getContent(Object.class);
            if (message instanceof SoapMessage) {
                if (m == Service.Mode.MESSAGE) {
                    if (obj instanceof SOAPMessage) {
                        ((SOAPMessage)obj).writeTo(os);
                    } else if (obj instanceof Source) {
                        this.doTransform(obj, os);
                    } else if (obj instanceof DataSource) {
                        throw new RuntimeException(obj.getClass() + " is not valid in Message mode for SOAP/HTTP");
                    }
                } else if (m == Service.Mode.PAYLOAD) {
                    SOAPMessage msg = this.initSOAPMessage();
                    DataWriter dataWriter = this.getDataWriter(message, SOAPBody.class);
                    if (obj instanceof Source || obj instanceof Object) {
                        dataWriter.write(obj, (Object)msg.getSOAPBody());
                    } else if (obj instanceof SOAPMessage || obj instanceof DataSource) {
                        throw new RuntimeException(obj.getClass() + " is not valid in PAYLOAD mode with SOAP/HTTP");
                    }
                    msg.writeTo(os);
                }
            } else if (message instanceof XMLMessage) {
                if (m == Service.Mode.MESSAGE && obj instanceof SOAPMessage) {
                    throw new RuntimeException("SOAPMessage is not valid in MESSAGE mode with XML/HTTP");
                }
                if (m == Service.Mode.PAYLOAD && (obj instanceof SOAPMessage || obj instanceof DataSource)) {
                    throw new RuntimeException(obj.getClass() + " is not valid in PAYLOAD mode with XML/HTTP");
                }
                this.doTransform(obj, os);
            }
            os.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private SOAPMessage initSOAPMessage() throws SOAPException {
        SOAPMessage msg = MessageFactory.newInstance().createMessage();
        msg.setProperty("javax.xml.soap.write-xml-declaration", (Object)"true");
        msg.getSOAPPart().getEnvelope().addNamespaceDeclaration("xs", "http://www.w3.org/2001/XMLSchema");
        msg.getSOAPPart().getEnvelope().addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        return msg;
    }

    private void doTransform(Object obj, OutputStream os) throws TransformerException, IOException {
        if (obj instanceof Source) {
            Transformer transformer = XMLUtils.newTransformer();
            transformer.transform((Source)obj, new StreamResult(os));
        }
        if (obj instanceof DataSource) {
            IOUtils.copy((InputStream)((DataSource)obj).getInputStream(), (OutputStream)os);
        }
    }
}

