/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.WrapperHelper;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperClassInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = Logger.getLogger(WrapperClassInInterceptor.class.getName());

    public WrapperClassInInterceptor() {
        this.setPhase("post-logical");
    }

    public void handleMessage(Message message) throws Fault {
        Class<?> retType;
        BindingOperationInfo boi = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        if (boi == null) {
            return;
        }
        Method method = (Method)message.getExchange().get(Method.class);
        if (method != null && method.getName().endsWith("Async") && ((retType = method.getReturnType()).getName().equals("java.util.concurrent.Future") || retType.getName().equals("javax.xml.ws.Response"))) {
            return;
        }
        if (boi != null && boi.isUnwrappedCapable()) {
            BindingMessageInfo bmi;
            BindingOperationInfo boi2 = boi.getUnwrappedOperation();
            MessageInfo messageInfo = (MessageInfo)message.get(MessageInfo.class);
            if (messageInfo != null && ((MessagePartInfo)messageInfo.getMessageParts().get(0)).getTypeClass() == null) {
                return;
            }
            OperationInfo op = boi2.getOperationInfo();
            if (messageInfo == boi.getOperationInfo().getInput()) {
                messageInfo = op.getInput();
                bmi = boi2.getInput();
            } else {
                messageInfo = op.getOutput();
                bmi = boi2.getOutput();
            }
            List lst = (List)message.getContent(List.class);
            if (lst != null) {
                message.put(MessageInfo.class, (Object)messageInfo);
                message.put(BindingMessageInfo.class, (Object)bmi);
                message.getExchange().put(BindingOperationInfo.class, (Object)boi2);
                message.getExchange().put(OperationInfo.class, (Object)op);
            }
            if (this.isGET(message)) {
                LOG.info("WrapperClassInInterceptor skipped in HTTP GET method");
                return;
            }
            if (lst != null && lst.size() == 1) {
                if (messageInfo.getMessageParts().size() > 0) {
                    Object wrappedObject = lst.get(0);
                    lst.clear();
                    for (MessagePartInfo part : messageInfo.getMessageParts()) {
                        try {
                            Object elementType = null;
                            elementType = part.isElement() ? part.getElementQName().getLocalPart() : (part.getTypeQName() == null ? null : part.getTypeQName().getLocalPart());
                            Object obj = WrapperHelper.getWrappedPart((String)part.getName().getLocalPart(), wrappedObject, (String)elementType);
                            CastUtils.cast((List)lst, Object.class).add(obj);
                        }
                        catch (Exception e) {
                            throw new Fault((Throwable)e);
                        }
                    }
                } else {
                    lst.clear();
                }
            }
        }
    }
}

