/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.servlet.ServletController;
import org.apache.cxf.jaxws.servlet.ServletTransportFactory;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class CXFServlet
extends HttpServlet {
    static final String ADDRESS_PERFIX = "http://localhost/services";
    static final Map<String, WeakReference<Bus>> BUS_MAP = new Hashtable<String, WeakReference<Bus>>();
    static final Logger LOG = Logger.getLogger(CXFServlet.class.getName());
    protected Bus bus;
    private ServletTransportFactory servletTransportFactory;
    private ServletController controller;

    public ServletController createServletController() {
        return new ServletController(this.servletTransportFactory, this.getServletContext());
    }

    public ServletController getController() {
        return this.controller;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        WeakReference<Bus> ref;
        super.init(servletConfig);
        String busid = servletConfig.getInitParameter("bus.id");
        if (null != busid && null != (ref = BUS_MAP.get(busid))) {
            this.bus = (Bus)ref.get();
        }
        if (null == this.bus) {
            ServletContext svCtx = this.getServletContext();
            ApplicationContext ctx = (ApplicationContext)svCtx.getAttribute("interface org.springframework.web.context.WebApplicationContext.ROOT");
            if (ctx == null) {
                ctx = (ApplicationContext)svCtx.getAttribute("org.springframework.web.context.WebApplicationContext.ROOT");
            }
            this.bus = new SpringBusFactory(ctx).getDefaultBus();
        }
        if (null != busid) {
            BUS_MAP.put(busid, new WeakReference<Bus>(this.bus));
        }
        this.replaceDestionFactory();
        this.controller = this.createServletController();
        this.buildEndpoints(servletConfig);
    }

    protected void buildEndpoints(ServletConfig servletConfig) throws ServletException {
        InputStream ins;
        String location = servletConfig.getInitParameter("config-location");
        if (location == null) {
            location = "/WEB-INF/cxf-servlet.xml";
        }
        if ((ins = servletConfig.getServletContext().getResourceAsStream(location)) == null) {
            try {
                URIResolver resolver = new URIResolver(location);
                if (resolver.isResolved()) {
                    ins = resolver.getInputStream();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (ins != null) {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            builderFactory.setValidating(false);
            try {
                Document doc = builderFactory.newDocumentBuilder().parse(ins);
                for (Node nd = doc.getDocumentElement().getFirstChild(); nd != null; nd = nd.getNextSibling()) {
                    if (!"endpoint".equals(nd.getLocalName())) continue;
                    this.buildEndpoint(servletConfig, nd);
                }
            }
            catch (SAXException ex) {
                throw new ServletException((Throwable)ex);
            }
            catch (IOException ex) {
                throw new ServletException((Throwable)ex);
            }
            catch (ParserConfigurationException ex) {
                throw new ServletException((Throwable)ex);
            }
        }
    }

    protected DestinationFactory createServletTransportFactory() {
        if (this.servletTransportFactory == null) {
            this.servletTransportFactory = new ServletTransportFactory(this.bus);
        }
        return this.servletTransportFactory;
    }

    private void registerTransport(DestinationFactory factory, String namespace) {
        ((DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class)).registerDestinationFactory(namespace, factory);
    }

    public void buildEndpoint(ServletConfig servletConfig, Node node) throws ServletException {
        Element el = (Element)node;
        String implName = el.getAttribute("implementation");
        String serviceName = el.getAttribute("service");
        String wsdlName = el.getAttribute("wsdl");
        String portName = el.getAttribute("port");
        String urlPat = el.getAttribute("url-pattern");
        this.buildEndpoint(implName, serviceName, wsdlName, portName, urlPat);
    }

    public void buildEndpoint(String implName, String serviceName, String wsdlName, String portName, String urlPat) throws ServletException {
        try {
            Class cls = ClassLoaderUtils.loadClass((String)implName, ((Object)((Object)this)).getClass());
            Object impl = cls.newInstance();
            EndpointImpl ep = new EndpointImpl(this.bus, impl, (String)null);
            LOG.info("publish the servcie to {context}/ " + (urlPat.charAt(0) == '/' ? "" : "/") + urlPat);
            ep.publish(ADDRESS_PERFIX + (urlPat.charAt(0) == '/' ? "" : "/") + urlPat);
        }
        catch (ClassNotFoundException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (InstantiationException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    private void replaceDestionFactory() throws ServletException {
        DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
        try {
            DestinationFactory df = dfm.getDestinationFactory("http://cxf.apache.org/transports/http/configuration");
            if (df instanceof ServletTransportFactory) {
                this.servletTransportFactory = (ServletTransportFactory)df;
                return;
            }
        }
        catch (BusException e) {
            // empty catch block
        }
        DestinationFactory factory = this.createServletTransportFactory();
        this.registerTransport(factory, "http://schemas.xmlsoap.org/wsdl/soap/http");
        this.registerTransport(factory, "http://schemas.xmlsoap.org/soap/http");
        this.registerTransport(factory, "http://www.w3.org/2003/05/soap/bindings/HTTP/");
        this.registerTransport(factory, "http://schemas.xmlsoap.org/wsdl/http/");
        this.registerTransport(factory, "http://cxf.apache.org/transports/http/configuration");
        this.registerTransport(factory, "http://cxf.apache.org/bindings/xformat");
    }

    public void destroy() {
        String s = this.bus.getId();
        BUS_MAP.remove(s);
        this.bus.shutdown(true);
        new SpringBusFactory().setDefaultBus(null);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.controller.invoke(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.controller.invoke(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.controller.invoke(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.controller.invoke(request, response);
    }
}

