/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.io.AbstractWrappedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletDestination
implements Destination {
    public static final String HTTP_REQUEST = "HTTP_SERVLET_REQUEST";
    public static final String HTTP_RESPONSE = "HTTP_SERVLET_RESPONSE";
    static final Logger LOG = Logger.getLogger(ServletDestination.class.getName());
    private static final long serialVersionUID = 1L;
    protected final Bus bus;
    protected final ConduitInitiator conduitInitiator;
    protected final EndpointInfo endpointInfo;
    protected final EndpointReferenceType reference;
    protected String name;
    protected URL nurl;
    protected MessageObserver incomingObserver;

    public ServletDestination(Bus b, ConduitInitiator ci, EndpointInfo ei) throws IOException {
        this.bus = b;
        this.conduitInitiator = ci;
        this.endpointInfo = ei;
        this.reference = new EndpointReferenceType();
        AttributedURIType add = new AttributedURIType();
        add.setValue(ei.getAddress());
        this.reference.setAddress(add);
    }

    public EndpointReferenceType getAddress() {
        return this.reference;
    }

    protected void setHeaders(Message message) {
        List authorizationLines;
        String credentials;
        String authType;
        HashMap<String, List<String>> requestHeaders = new HashMap<String, List<String>>();
        this.copyRequestHeaders(message, requestHeaders);
        message.put((Object)Message.PROTOCOL_HEADERS, requestHeaders);
        if (requestHeaders.containsKey("Authorization") && "Basic".equals(authType = (credentials = (String)(authorizationLines = (List)requestHeaders.get("Authorization")).get(0)).split(" ")[0])) {
            String authEncoded = credentials.split(" ")[1];
            try {
                String authDecoded = new String(Base64Utility.decode((String)authEncoded));
                String[] authInfo = authDecoded.split(":");
                String username = authInfo[0];
                String password = authInfo[1];
                AuthorizationPolicy policy = new AuthorizationPolicy();
                policy.setUserName(username);
                policy.setPassword(password);
                message.put(AuthorizationPolicy.class, (Object)policy);
            }
            catch (Base64Exception ex) {
                // empty catch block
            }
        }
    }

    protected void updateResponseHeaders(Message message) {
        HashMap responseHeaders = (HashMap)message.get((Object)Message.PROTOCOL_HEADERS);
        if (responseHeaders == null) {
            responseHeaders = new HashMap();
            message.put((Object)Message.PROTOCOL_HEADERS, responseHeaders);
        }
    }

    public synchronized void setMessageObserver(MessageObserver observer) {
        LOG.info("set the observer for address " + this.getAddress().getAddress().getValue());
        this.incomingObserver = observer;
    }

    public Conduit getBackChannel(Message inMessage, Message partialResponse, EndpointReferenceType address) throws IOException {
        HttpServletResponse response = (HttpServletResponse)inMessage.get((Object)HTTP_RESPONSE);
        BackChannelConduit backChannel = null;
        if (address == null) {
            backChannel = new BackChannelConduit(address, response);
        } else if (partialResponse != null) {
            partialResponse.put((Object)Message.RESPONSE_CODE, (Object)202);
            backChannel = new BackChannelConduit(address, response);
        } else {
            backChannel = this.conduitInitiator.getConduit(this.endpointInfo, address);
            backChannel.setMessageObserver(new MessageObserver(){

                public void onMessage(Message m) {
                    if (m.getContentFormats().contains(InputStream.class)) {
                        InputStream is = (InputStream)m.getContent(InputStream.class);
                        try {
                            is.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        return backChannel;
    }

    public void shutdown() {
    }

    protected void copyRequestHeaders(Message message, Map<String, List<String>> headers) {
        HttpServletRequest req = (HttpServletRequest)message.get((Object)HTTP_REQUEST);
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            List<Object> values;
            String fname = (String)e.nextElement();
            if (headers.containsKey(fname)) {
                values = headers.get(fname);
            } else {
                values = new ArrayList();
                headers.put(HttpHeaderHelper.getHeaderKey((String)fname), values);
            }
            Enumeration e2 = req.getHeaders(fname);
            while (e2.hasMoreElements()) {
                String val = (String)e2.nextElement();
                values.add(val);
            }
        }
    }

    protected void copyResponseHeaders(Message message, HttpServletResponse response) {
        String ct = (String)message.get((Object)Message.CONTENT_TYPE);
        String enc = (String)message.get((Object)Message.ENCODING);
        if (null != ct) {
            if (enc != null && ct.indexOf("charset=") == -1) {
                ct = ct + "; charset=" + enc;
            }
            response.setContentType(ct);
        } else if (enc != null) {
            response.setContentType("text/xml; charset=" + enc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMessage(MessageImpl inMessage) throws IOException {
        try {
            this.setHeaders((Message)inMessage);
            inMessage.setDestination((Destination)this);
            this.incomingObserver.onMessage((Message)inMessage);
        }
        finally {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Finished servicing http request on thread: " + Thread.currentThread());
            }
        }
    }

    protected OutputStream flushHeaders(Message outMessage) throws IOException {
        this.updateResponseHeaders(outMessage);
        Object responseObj = outMessage.get((Object)HTTP_RESPONSE);
        ServletOutputStream responseStream = null;
        if (responseObj instanceof HttpServletResponse) {
            HttpServletResponse response = (HttpServletResponse)responseObj;
            Integer i = (Integer)outMessage.get((Object)Message.RESPONSE_CODE);
            if (i != null) {
                int status = i;
                response.setStatus(status);
            } else {
                response.setStatus(200);
            }
            this.copyResponseHeaders(outMessage, response);
            responseStream = response.getOutputStream();
            if (this.isOneWay(outMessage)) {
                response.flushBuffer();
            }
        } else {
            LOG.log(Level.WARNING, "UNEXPECTED_RESPONSE_TYPE_MSG", responseObj.getClass());
            throw new IOException("UNEXPECTED_RESPONSE_TYPE_MSG" + responseObj.getClass());
        }
        if (this.isOneWay(outMessage)) {
            outMessage.remove((Object)HTTP_RESPONSE);
        }
        return responseStream;
    }

    protected boolean isOneWay(Message message) {
        return message.getExchange() != null && message.getExchange().isOneWay();
    }

    public MessageObserver getMessageObserver() {
        return this.incomingObserver;
    }

    public EndpointInfo getEndpointInfo() {
        return this.endpointInfo;
    }

    private class WrappedOutputStream
    extends AbstractWrappedOutputStream {
        protected HttpServletResponse response;

        WrappedOutputStream(Message m, HttpServletResponse resp) {
            super(m);
            this.response = resp;
        }

        protected void doFlush() throws IOException {
            OutputStream responseStream = ServletDestination.this.flushHeaders(this.outMessage);
            if (null != responseStream && !this.alreadyFlushed()) {
                this.resetOut(responseStream, true);
            }
        }

        protected void doClose() {
            this.commitResponse();
        }

        protected void onWrite() throws IOException {
        }

        private void commitResponse() {
            try {
                this.response.flushBuffer();
            }
            catch (IOException e) {
                LOG.severe(e.getMessage());
            }
        }
    }

    protected class BackChannelConduit
    implements Conduit {
        protected HttpServletResponse response;
        protected EndpointReferenceType target;

        BackChannelConduit(EndpointReferenceType ref, HttpServletResponse resp) {
            this.response = resp;
            this.target = ref;
        }

        public void close(Message msg) throws IOException {
            ((OutputStream)msg.getContent(OutputStream.class)).close();
        }

        public void setMessageObserver(MessageObserver observer) {
        }

        public void send(Message message) throws IOException {
            message.put((Object)ServletDestination.HTTP_RESPONSE, (Object)this.response);
            message.setContent(OutputStream.class, (Object)new WrappedOutputStream(message, this.response));
        }

        public EndpointReferenceType getTarget() {
            return this.target;
        }

        public Destination getBackChannel() {
            return null;
        }

        public void close() {
        }
    }
}

