/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.support;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingType;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceProvider;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxb.JAXBEncoderDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsImplementorInfo {
    private static final Logger LOG = LogUtils.getL7dLogger(JaxWsImplementorInfo.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();
    private Class<?> implementorClass;
    private Class<?> seiClass;
    private WebService implementorAnnotation;
    private WebService seiAnnotation;
    private WebServiceProvider wsProviderAnnotation;

    public JaxWsImplementorInfo(Class<?> ic) {
        this.implementorClass = ic;
        this.initialise();
    }

    public Class<?> getSEIClass() {
        return this.seiClass;
    }

    public Class<?> getImplementorClass() {
        return this.implementorClass;
    }

    public Class<?> getEndpointClass() {
        Class<?> endpointInterface = this.getSEIClass();
        if (null == endpointInterface) {
            endpointInterface = this.getImplementorClass();
        }
        return endpointInterface;
    }

    public String getWsdlLocation() {
        if (null != this.seiAnnotation) {
            return this.seiAnnotation.wsdlLocation();
        }
        if (null != this.implementorAnnotation) {
            return this.implementorAnnotation.wsdlLocation();
        }
        if (null != this.wsProviderAnnotation) {
            return this.wsProviderAnnotation.wsdlLocation();
        }
        return null;
    }

    public QName getServiceName() {
        String serviceName = null;
        String namespace = null;
        if (this.implementorAnnotation != null) {
            serviceName = this.implementorAnnotation.serviceName();
            namespace = this.implementorAnnotation.targetNamespace();
        } else {
            serviceName = this.wsProviderAnnotation.serviceName();
            namespace = this.wsProviderAnnotation.targetNamespace();
        }
        if (StringUtils.isEmpty((String)serviceName)) {
            serviceName = this.implementorClass.getName();
        }
        if (!StringUtils.isEmpty((String)namespace) && !StringUtils.isEmpty((String)serviceName)) {
            return new QName(namespace, serviceName);
        }
        return null;
    }

    public QName getEndpointName() {
        String portName = null;
        String namespace = null;
        if (this.implementorAnnotation != null) {
            portName = this.implementorAnnotation.portName();
            namespace = this.implementorAnnotation.targetNamespace();
        } else {
            portName = this.wsProviderAnnotation.portName();
            namespace = this.wsProviderAnnotation.targetNamespace();
        }
        if (StringUtils.isEmpty((String)portName)) {
            portName = this.implementorClass.getSimpleName() + "Port";
        }
        if (!StringUtils.isEmpty((String)portName)) {
            return new QName(namespace, portName);
        }
        return new QName(namespace, "NoNamedPort");
    }

    private String getWSInterfaceName(Class implClz) {
        Class<?>[] clzs;
        for (Class<?> clz : clzs = implClz.getInterfaces()) {
            if (null == clz.getAnnotation(WebService.class)) continue;
            return clz.getName();
        }
        return null;
    }

    private void initialise() {
        this.implementorAnnotation = this.implementorClass.getAnnotation(WebService.class);
        if (null != this.implementorAnnotation) {
            String sei = this.implementorAnnotation.endpointInterface();
            if (StringUtils.isEmpty((String)sei)) {
                sei = this.getWSInterfaceName(this.implementorClass);
            }
            if (!StringUtils.isEmpty((String)sei)) {
                try {
                    this.seiClass = ClassLoaderUtils.loadClass((String)sei, this.implementorClass);
                }
                catch (ClassNotFoundException ex) {
                    throw new WebServiceException(BUNDLE.getString("SEI_LOAD_FAILURE_MSG"), (Throwable)ex);
                }
                this.seiAnnotation = this.seiClass.getAnnotation(WebService.class);
                if (null == this.seiAnnotation) {
                    throw new WebServiceException(BUNDLE.getString("SEI_WITHOUT_WEBSERVICE_ANNOTATION_EXC"));
                }
                if (!(StringUtils.isEmpty((String)this.seiAnnotation.portName()) && StringUtils.isEmpty((String)this.seiAnnotation.serviceName()) && StringUtils.isEmpty((String)this.seiAnnotation.endpointInterface()))) {
                    String expString = BUNDLE.getString("ILLEGAL_ATTRIBUTE_IN_SEI_ANNOTATION_EXC");
                    throw new WebServiceException(expString);
                }
            }
        } else {
            this.wsProviderAnnotation = this.implementorClass.getAnnotation(WebServiceProvider.class);
        }
    }

    public boolean isWebServiceProvider() {
        return Provider.class.isAssignableFrom(this.implementorClass);
    }

    public WebServiceProvider getWsProvider() {
        return this.wsProviderAnnotation;
    }

    public Service.Mode getServiceMode() {
        ServiceMode m = this.implementorClass.getAnnotation(ServiceMode.class);
        if (m != null && m.value() != null) {
            return m.value();
        }
        return Service.Mode.PAYLOAD;
    }

    public Class<?> getProviderParameterType() {
        Type[] intfTypes;
        for (Type t : intfTypes = this.implementorClass.getGenericInterfaces()) {
            Class clazz = JAXBEncoderDecoder.getClassFromType((Type)t);
            if (Provider.class != clazz) continue;
            Type[] paramTypes = ((ParameterizedType)t).getActualTypeArguments();
            return JAXBEncoderDecoder.getClassFromType((Type)paramTypes[0]);
        }
        return null;
    }

    public String getBindingType() {
        BindingType bType = this.implementorClass.getAnnotation(BindingType.class);
        if (bType != null) {
            return bType.value();
        }
        return "http://schemas.xmlsoap.org/wsdl/soap/http";
    }
}

