/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.ws.rm.AbstractEndpoint;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.Identifier;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.SequenceFaultFactory;
import org.apache.cxf.ws.rm.SequenceType;
import org.apache.cxf.ws.rm.persistence.RMStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Destination
extends AbstractEndpoint {
    private static final Logger LOG = LogUtils.getL7dLogger(Destination.class);
    private Map<String, DestinationSequence> map = new HashMap<String, DestinationSequence>();

    Destination(RMEndpoint reliableEndpoint) {
        super(reliableEndpoint);
    }

    public DestinationSequence getSequence(Identifier id) {
        return this.map.get(id.getValue());
    }

    public Collection<DestinationSequence> getAllSequences() {
        return CastUtils.cast(this.map.values());
    }

    public void addSequence(DestinationSequence seq) {
        this.addSequence(seq, true);
    }

    public void addSequence(DestinationSequence seq, boolean persist) {
        RMStore store;
        seq.setDestination(this);
        this.map.put(seq.getIdentifier().getValue(), seq);
        if (persist && null != (store = this.getReliableEndpoint().getManager().getStore())) {
            store.createDestinationSequence(seq);
        }
    }

    public void removeSequence(DestinationSequence seq) {
        this.map.remove(seq.getIdentifier().getValue());
        RMStore store = this.getReliableEndpoint().getManager().getStore();
        if (null != store) {
            store.removeDestinationSequence(seq.getIdentifier());
        }
    }

    public void acknowledge(SequenceType sequenceType, String replyToAddress) throws SequenceFault {
        DestinationSequence seq = this.getSequence(sequenceType.getIdentifier());
        if (null != seq) {
            seq.acknowledge(sequenceType.getMessageNumber());
            if (null != sequenceType.getLastMessage()) {
                seq.setLastMessageNumber(sequenceType.getMessageNumber());
                seq.scheduleImmediateAcknowledgement();
                if (!seq.getAcksTo().getAddress().getValue().equals(replyToAddress) && !seq.canPiggybackAckOnPartialResponse()) {
                    try {
                        this.getReliableEndpoint().getProxy().acknowledge(seq);
                    }
                    catch (IOException ex) {
                        Message msg = new Message("SEQ_ACK_SEND_EXC", LOG, new Object[]{seq});
                        LOG.log(Level.SEVERE, msg.toString(), ex);
                    }
                }
            }
        } else {
            SequenceFaultFactory sff = new SequenceFaultFactory();
            throw sff.createUnknownSequenceFault(sequenceType.getIdentifier());
        }
    }
}

