/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.ws.addressing.v200408.EndpointReferenceType;
import org.apache.cxf.ws.rm.AbstractSequence;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.Identifier;
import org.apache.cxf.ws.rm.Proxy;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.SequenceFaultType;
import org.apache.cxf.ws.rm.SequenceMonitor;
import org.apache.cxf.ws.rm.manager.AcksPolicyType;
import org.apache.cxf.ws.rm.manager.DeliveryAssuranceType;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.policy.RMAssertion;

public class DestinationSequence
extends AbstractSequence {
    private static final Logger LOG = LogUtils.getL7dLogger(DestinationSequence.class);
    private Destination destination;
    private EndpointReferenceType acksTo;
    private BigInteger lastMessageNumber;
    private SequenceMonitor monitor;
    private boolean acknowledgeOnNextOccasion;
    private List<DeferredAcknowledgment> deferredAcknowledgments;
    private String correlationID;

    public DestinationSequence(Identifier i, EndpointReferenceType a, Destination d) {
        this(i, a, null, null);
        this.setDestination(d);
    }

    public DestinationSequence(Identifier i, EndpointReferenceType a, BigInteger lmn, SequenceAcknowledgement ac) {
        super(i);
        this.acksTo = a;
        this.lastMessageNumber = lmn;
        this.acknowledgement = ac;
        if (null == this.acknowledgement) {
            this.acknowledgement = RMUtils.getWSRMFactory().createSequenceAcknowledgement();
            this.acknowledgement.setIdentifier(this.id);
        }
        this.monitor = new SequenceMonitor();
    }

    public EndpointReferenceType getAcksTo() {
        return this.acksTo;
    }

    public BigInteger getLastMessageNumber() {
        return this.lastMessageNumber;
    }

    public SequenceAcknowledgement getAcknowledgment() {
        return this.acknowledgement;
    }

    InputStream getAcknowledgmentAsStream() {
        return null;
    }

    public String getEndpointIdentifier() {
        return this.destination.getName().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledge(BigInteger messageNumber) throws SequenceFault {
        if (null != this.lastMessageNumber && messageNumber.compareTo(this.lastMessageNumber) > 0) {
            SequenceFaultType sf = RMUtils.getWSRMFactory().createSequenceFaultType();
            sf.setFaultCode(RMConstants.getLastMessageNumberExceededFaultCode());
            Message msg = new Message("LAST_MESSAGE_NUMBER_EXCEEDED_EXC", LOG, new Object[]{this});
            throw new SequenceFault(msg.toString(), sf);
        }
        this.monitor.acknowledgeMessage();
        DestinationSequence destinationSequence = this;
        synchronized (destinationSequence) {
            int i;
            boolean done = false;
            for (i = 0; i < this.acknowledgement.getAcknowledgementRange().size(); ++i) {
                SequenceAcknowledgement.AcknowledgementRange r = this.acknowledgement.getAcknowledgementRange().get(i);
                if (r.getLower().compareTo(messageNumber) <= 0 && r.getUpper().compareTo(messageNumber) >= 0) {
                    done = true;
                    break;
                }
                BigInteger diff = r.getLower().subtract(messageNumber);
                if (diff.signum() == 1) {
                    if (!diff.equals(BigInteger.ONE)) break;
                    r.setLower(messageNumber);
                    done = true;
                    break;
                }
                if (!messageNumber.subtract(r.getUpper()).equals(BigInteger.ONE)) continue;
                r.setUpper(messageNumber);
                done = true;
                break;
            }
            if (!done) {
                SequenceAcknowledgement.AcknowledgementRange range = RMUtils.getWSRMFactory().createSequenceAcknowledgementAcknowledgementRange();
                range.setLower(messageNumber);
                range.setUpper(messageNumber);
                this.acknowledgement.getAcknowledgementRange().add(i, range);
            }
            this.notifyAll();
        }
        this.purgeAcknowledged(messageNumber);
        this.scheduleAcknowledgement();
    }

    final void setDestination(Destination d) {
        this.destination = d;
    }

    Destination getDestination() {
        return this.destination;
    }

    SequenceMonitor getMonitor() {
        return this.monitor;
    }

    void setLastMessageNumber(BigInteger lmn) {
        this.lastMessageNumber = lmn;
    }

    boolean canPiggybackAckOnPartialResponse() {
        return this.getAcksTo().getAddress().getValue().equals(RMConstants.getAnonymousAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean applyDeliveryAssurance(BigInteger mn) {
        DeliveryAssuranceType da = this.destination.getManager().getDeliveryAssurance();
        if (da.isSetAtMostOnce() && this.isAcknowledged(mn)) {
            Message msg = new Message("MESSAGE_ALREADY_DELIVERED", LOG, new Object[]{mn, this.getIdentifier().getValue()});
            LOG.log(Level.SEVERE, msg.toString());
            return false;
        }
        if (da.isSetInOrder() && da.isSetAtLeastOnce()) {
            DestinationSequence destinationSequence = this;
            synchronized (destinationSequence) {
                boolean ok = this.allPredecessorsAcknowledged(mn);
                while (!ok) {
                    try {
                        this.wait();
                        ok = this.allPredecessorsAcknowledged(mn);
                    }
                    catch (InterruptedException ie) {}
                }
            }
        }
        return true;
    }

    synchronized boolean allPredecessorsAcknowledged(BigInteger mn) {
        return this.acknowledgement.getAcknowledgementRange().size() == 1 && this.acknowledgement.getAcknowledgementRange().get(0).getLower().equals(BigInteger.ONE) && this.acknowledgement.getAcknowledgementRange().get(0).getUpper().subtract(mn).signum() >= 0;
    }

    void purgeAcknowledged(BigInteger messageNr) {
        RMStore store = this.destination.getManager().getStore();
        if (null == store) {
            return;
        }
        ArrayList<BigInteger> messageNrs = new ArrayList<BigInteger>();
        messageNrs.add(messageNr);
        store.removeMessages(this.getIdentifier(), messageNrs, false);
    }

    void acknowledgmentSent() {
        this.acknowledgeOnNextOccasion = false;
    }

    public boolean sendAcknowledgement() {
        return this.acknowledgeOnNextOccasion;
    }

    void setCorrelationID(String cid) {
        this.correlationID = cid;
    }

    String getCorrelationID() {
        return this.correlationID;
    }

    void scheduleAcknowledgement() {
        RMAssertion rma = this.destination.getManager().getRMAssertion();
        int delay = 0;
        if (null != rma.getAcknowledgementInterval()) {
            delay = rma.getAcknowledgementInterval().getMilliseconds().intValue();
        }
        AcksPolicyType ap = this.destination.getManager().getDestinationPolicy().getAcksPolicy();
        if (delay > 0 && this.getMonitor().getMPM() >= ap.getIntraMessageThreshold()) {
            this.scheduleDeferredAcknowledgement(delay);
        } else {
            this.scheduleImmediateAcknowledgement();
        }
    }

    void scheduleImmediateAcknowledgement() {
        this.acknowledgeOnNextOccasion = true;
    }

    synchronized void scheduleDeferredAcknowledgement(int delay) {
        if (null == this.deferredAcknowledgments) {
            this.deferredAcknowledgments = new ArrayList<DeferredAcknowledgment>();
        }
        long now = System.currentTimeMillis();
        long expectedExecutionTime = now + (long)delay;
        for (DeferredAcknowledgment da : this.deferredAcknowledgments) {
            if (da.scheduledExecutionTime() > expectedExecutionTime) continue;
            return;
        }
        DeferredAcknowledgment da = new DeferredAcknowledgment();
        this.deferredAcknowledgments.add(da);
        this.destination.getManager().getTimer().schedule((TimerTask)da, delay);
        LOG.fine("Scheduled acknowledgment to be sent in " + delay + " ms");
    }

    final class DeferredAcknowledgment
    extends TimerTask {
        DeferredAcknowledgment() {
        }

        public void run() {
            LOG.fine("timer task: send acknowledgment.");
            DestinationSequence.this.scheduleImmediateAcknowledgement();
            try {
                RMEndpoint rme = DestinationSequence.this.destination.getReliableEndpoint();
                Proxy proxy = rme.getProxy();
                proxy.acknowledge(DestinationSequence.this);
            }
            catch (IOException ex) {
                Message msg = new Message("SEQ_ACK_SEND_EXC", LOG, new Object[]{DestinationSequence.this});
                LOG.log(Level.SEVERE, msg.toString(), ex);
            }
        }
    }
}

