/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.RelatesToType;
import org.apache.cxf.ws.addressing.VersionTransformer;
import org.apache.cxf.ws.addressing.v200408.EndpointReferenceType;
import org.apache.cxf.ws.rm.CreateSequenceResponseType;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.Identifier;
import org.apache.cxf.ws.rm.Proxy;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.RetransmissionQueue;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.Servant;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.manager.DeliveryAssuranceType;
import org.apache.cxf.ws.rm.manager.DestinationPolicyType;
import org.apache.cxf.ws.rm.manager.RMManagerConfigBean;
import org.apache.cxf.ws.rm.manager.SourcePolicyType;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.policy.ObjectFactory;
import org.apache.cxf.ws.rm.policy.RMAssertion;
import org.apache.cxf.ws.rm.soap.RetransmissionQueueImpl;

public class RMManager
extends RMManagerConfigBean {
    private Bus bus;
    private RMStore store;
    private RetransmissionQueue retransmissionQueue;
    private Map<Endpoint, RMEndpoint> reliableEndpoints = new HashMap<Endpoint, RMEndpoint>();
    private Map<String, SourceSequence> sourceSequences;
    private Timer timer = new Timer();

    public Bus getBus() {
        return this.bus;
    }

    @Resource
    public void setBus(Bus b) {
        this.bus = b;
    }

    @PostConstruct
    public void register() {
        if (null != this.bus) {
            this.bus.setExtension((Object)this, RMManager.class);
        }
        if (null == this.retransmissionQueue) {
            this.retransmissionQueue = new RetransmissionQueueImpl(this);
        }
    }

    public RMStore getStore() {
        return this.store;
    }

    public void setStore(RMStore s) {
        this.store = s;
    }

    public RetransmissionQueue getRetransmissionQueue() {
        return this.retransmissionQueue;
    }

    public void setRetransmissionQueue(RetransmissionQueue rq) {
        this.retransmissionQueue = rq;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public synchronized RMEndpoint getReliableEndpoint(Endpoint e) {
        return this.reliableEndpoints.get(e);
    }

    public synchronized RMEndpoint getReliableEndpoint(Message message) {
        Endpoint endpoint = RMContextUtils.getEndpoint(message);
        RMEndpoint rme = this.reliableEndpoints.get(endpoint);
        if (null == rme) {
            rme = new RMEndpoint(this, endpoint);
            org.apache.cxf.transport.Destination destination = message.getExchange().getDestination();
            org.apache.cxf.ws.addressing.EndpointReferenceType replyTo = null;
            if (null != destination) {
                AddressingPropertiesImpl maps = RMContextUtils.retrieveMAPs(message, false, false);
                replyTo = maps.getReplyTo();
            }
            rme.initialise(replyTo);
            this.reliableEndpoints.put(endpoint, rme);
        }
        return rme;
    }

    public Destination getDestination(Message message) {
        RMEndpoint rme = this.getReliableEndpoint(message);
        if (null != rme) {
            return rme.getDestination();
        }
        return null;
    }

    public SourceSequence getSourceSequence(Identifier id) {
        return this.sourceSequences.get(id.getValue());
    }

    public Source getSource(Message message) {
        RMEndpoint rme = this.getReliableEndpoint(message);
        if (null != rme) {
            return rme.getSource();
        }
        return null;
    }

    public SourceSequence getSequence(Identifier inSeqId, Message message, AddressingProperties maps) throws SequenceFault {
        Source source = this.getSource(message);
        SourceSequence seq = source.getCurrent(inSeqId);
        if (null == seq) {
            org.apache.cxf.ws.addressing.EndpointReferenceType to = null;
            try {
                EndpointReferenceType acksTo = null;
                RelatesToType relatesTo = null;
                if (RMContextUtils.isServerSide(message)) {
                    AddressingPropertiesImpl inMaps = RMContextUtils.retrieveMAPs(message, false, false);
                    inMaps.exposeAs("http://schemas.xmlsoap.org/ws/2004/08/addressing");
                    acksTo = RMUtils.createReference2004(inMaps.getTo().getValue());
                    to = inMaps.getReplyTo();
                    relatesTo = new org.apache.cxf.ws.addressing.ObjectFactory().createRelatesToType();
                    Destination destination = this.getDestination(message);
                    DestinationSequence inSeq = destination.getSequence(inSeqId);
                    relatesTo.setValue(inSeq != null ? inSeq.getCorrelationID() : null);
                } else {
                    to = RMUtils.createReference(maps.getTo().getValue());
                    acksTo = VersionTransformer.convert((org.apache.cxf.ws.addressing.EndpointReferenceType)maps.getReplyTo());
                    if (!RMContextUtils.isServerSide(message) && RMConstants.getNoneAddress().equals(acksTo.getAddress().getValue())) {
                        org.apache.cxf.transport.Destination dest = message.getExchange().getConduit().getBackChannel();
                        acksTo = null == dest ? RMUtils.createAnonymousReference2004() : VersionTransformer.convert((org.apache.cxf.ws.addressing.EndpointReferenceType)dest.getAddress());
                    }
                }
                Proxy proxy = source.getReliableEndpoint().getProxy();
                CreateSequenceResponseType createResponse = proxy.createSequence(to, acksTo, relatesTo);
                Servant servant = source.getReliableEndpoint().getServant();
                servant.createSequenceResponse(createResponse);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            seq = source.getCurrent(inSeqId);
            seq.setTarget(to);
        }
        return seq;
    }

    @PostConstruct
    void initialise() {
        Object factory;
        if (!this.isSetRMAssertion()) {
            factory = new ObjectFactory();
            RMAssertion rma = ((ObjectFactory)factory).createRMAssertion();
            RMAssertion.BaseRetransmissionInterval bri = ((ObjectFactory)factory).createRMAssertionBaseRetransmissionInterval();
            bri.setMilliseconds(new BigInteger("3000"));
            rma.setBaseRetransmissionInterval(bri);
            rma.setExponentialBackoff(((ObjectFactory)factory).createRMAssertionExponentialBackoff());
            this.setRMAssertion(rma);
        }
        factory = new org.apache.cxf.ws.rm.manager.ObjectFactory();
        if (!this.isSetDeliveryAssurance()) {
            DeliveryAssuranceType da = ((org.apache.cxf.ws.rm.manager.ObjectFactory)factory).createDeliveryAssuranceType();
            da.setAtLeastOnce(((org.apache.cxf.ws.rm.manager.ObjectFactory)factory).createDeliveryAssuranceTypeAtLeastOnce());
            this.setDeliveryAssurance(da);
        }
        if (!this.isSetSourcePolicy()) {
            SourcePolicyType sp = ((org.apache.cxf.ws.rm.manager.ObjectFactory)factory).createSourcePolicyType();
            this.setSourcePolicy(sp);
        }
        if (!this.getSourcePolicy().isSetSequenceTerminationPolicy()) {
            this.getSourcePolicy().setSequenceTerminationPolicy(((org.apache.cxf.ws.rm.manager.ObjectFactory)factory).createSequenceTerminationPolicyType());
        }
        if (!this.isSetDestinationPolicy()) {
            DestinationPolicyType dp = ((org.apache.cxf.ws.rm.manager.ObjectFactory)factory).createDestinationPolicyType();
            dp.setAcksPolicy(((org.apache.cxf.ws.rm.manager.ObjectFactory)factory).createAcksPolicyType());
            this.setDestinationPolicy(dp);
        }
    }

    void addSourceSequence(SourceSequence ss) {
        if (null == this.sourceSequences) {
            this.sourceSequences = new HashMap<String, SourceSequence>();
        }
        this.sourceSequences.put(ss.getIdentifier().getValue(), ss);
    }

    void removeSourceSequence(Identifier id) {
        if (null != this.sourceSequences) {
            this.sourceSequences.remove(id.getValue());
        }
    }
}

