/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.addressing.VersionTransformer;
import org.apache.cxf.ws.addressing.v200408.AttributedURI;
import org.apache.cxf.ws.rm.AbstractRMInterceptor;
import org.apache.cxf.ws.rm.AbstractSequence;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.Identifier;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.RetransmissionInterceptor;
import org.apache.cxf.ws.rm.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.SourceSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMOutInterceptor
extends AbstractRMInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(RMOutInterceptor.class);
    private Set<String> after = Collections.singleton(MAPAggregator.class.getName());

    public Set<String> getAfter() {
        return this.after;
    }

    public Set<String> getBefore() {
        return CastUtils.cast((Set)Collections.EMPTY_SET);
    }

    public String getId() {
        return RMOutInterceptor.class.getName();
    }

    @Override
    void handleMessage(Message message, boolean isFault) throws SequenceFault {
        RMProperties rmpsOut;
        LOG.entering(this.getClass().getName(), "handleMessage");
        AddressingPropertiesImpl maps = RMContextUtils.retrieveMAPs(message, false, true);
        RMContextUtils.ensureExposedVersion((AddressingProperties)maps);
        Source source = this.getManager().getSource(message);
        Destination destination = this.getManager().getDestination(message);
        String action = null;
        if (maps != null && null != maps.getAction()) {
            action = maps.getAction().getValue();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Action: " + action);
        }
        boolean isApplicationMessage = RMContextUtils.isAplicationMessage(action);
        boolean isPartialResponse = RMContextUtils.isPartialResponse(message);
        LOG.fine("isApplicationMessage: " + isApplicationMessage);
        LOG.fine("isPartialResponse: " + isPartialResponse);
        if (isApplicationMessage && !isPartialResponse) {
            RetransmissionInterceptor ri = new RetransmissionInterceptor();
            ri.setManager(this.getManager());
            message.getInterceptorChain().add((Interceptor)ri);
            LOG.fine("Added RetransmissionInterceptor to chain.");
            this.getManager().getRetransmissionQueue().start();
        }
        if (null == (rmpsOut = RMContextUtils.retrieveRMProperties(message, true))) {
            rmpsOut = new RMProperties();
            RMContextUtils.storeRMProperties(message, rmpsOut, true);
        }
        RMProperties rmpsIn = null;
        Identifier inSeqId = null;
        BigInteger inMessageNumber = null;
        if (isApplicationMessage && !isPartialResponse) {
            rmpsIn = RMContextUtils.retrieveRMProperties(message, false);
            if (null != rmpsIn && null != rmpsIn.getSequence()) {
                inSeqId = rmpsIn.getSequence().getIdentifier();
                inMessageNumber = rmpsIn.getSequence().getMessageNumber();
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("inbound sequence: " + (null == inSeqId ? "null" : inSeqId.getValue()));
            }
            SourceSequence seq = this.getManager().getSequence(inSeqId, message, (AddressingProperties)maps);
            assert (null != seq);
            seq.nextMessageNumber(inSeqId, inMessageNumber);
            rmpsOut.setSequence(seq);
            if (seq.isLastMessage()) {
                source.setCurrent(null);
            }
        } else if (!RMContextUtils.isRequestor(message) && RMConstants.getCreateSequenceAction().equals(action)) {
            maps.getAction().setValue(RMConstants.getCreateSequenceResponseAction());
        }
        if (isApplicationMessage || RMConstants.getSequenceAcknowledgmentAction().equals(action)) {
            AttributedURI to = VersionTransformer.convert((AttributedURIType)maps.getTo());
            assert (null != to);
            this.addAcknowledgements(destination, rmpsOut, inSeqId, to);
        }
        if (RMConstants.getSequenceAckAction().equals(action) || RMConstants.getTerminateSequenceAction().equals(action)) {
            maps.setReplyTo(RMUtils.createNoneReference());
        }
    }

    void addAcknowledgements(Destination destination, RMProperties rmpsOut, Identifier inSeqId, AttributedURI to) {
        for (DestinationSequence seq : destination.getAllSequences()) {
            if (seq.sendAcknowledgement() && (seq.getAcksTo().getAddress().getValue().equals(RMUtils.getAddressingConstants().getAnonymousURI()) && AbstractSequence.identifierEquals(seq.getIdentifier(), inSeqId) || to.getValue().equals(seq.getAcksTo().getAddress().getValue()))) {
                rmpsOut.addAck(seq);
                continue;
            }
            if (!LOG.isLoggable(Level.FINE)) continue;
            if (!seq.sendAcknowledgement()) {
                LOG.fine("no need to add an acknowledgements for sequence " + seq.getIdentifier().getValue());
                continue;
            }
            LOG.fine("sequences acksTo address (" + seq.getAcksTo().getAddress().getValue() + ") does not match to address (" + to.getValue() + ")");
        }
        if (LOG.isLoggable(Level.FINE)) {
            Collection<SequenceAcknowledgement> acks = rmpsOut.getAcks();
            if (null == acks) {
                LOG.fine("No acknowledgements added");
            } else {
                LOG.fine("Added " + acks.size() + " acknowledgements.");
            }
        }
    }
}

