/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.soap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.soap.MAPCodec;
import org.apache.cxf.ws.rm.AbstractRMInterceptor;
import org.apache.cxf.ws.rm.AckRequestedType;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.SequenceType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMSoapInterceptor
extends AbstractSoapInterceptor {
    protected static JAXBContext jaxbContext;
    private static final Logger LOG;
    private static final String WS_RM_PACKAGE;
    private Set<String> after = Collections.singleton(MAPCodec.class.getName());

    public Set<String> getBefore() {
        return CastUtils.cast((Set)Collections.EMPTY_SET);
    }

    public Set<String> getAfter() {
        return this.after;
    }

    public String getId() {
        return RMSoapInterceptor.class.getName();
    }

    public String getPhase() {
        return "pre-protocol";
    }

    public Set<QName> getUnderstoodHeaders() {
        return RMConstants.getHeaders();
    }

    public void handleFault(SoapMessage message) {
        this.mediate(message);
    }

    public void handleMessage(SoapMessage message) throws Fault {
        this.mediate(message);
    }

    void mediate(SoapMessage message) {
        if (RMContextUtils.isOutbound((Message)message)) {
            this.encode(message);
        } else {
            this.decode(message);
            this.updateServiceModelInfo(message);
        }
    }

    void encode(SoapMessage message) {
        RMProperties rmps = RMContextUtils.retrieveRMProperties((Message)message, true);
        if (null == rmps) {
            return;
        }
        RMSoapInterceptor.encode(message, rmps);
    }

    public static void encode(SoapMessage message, RMProperties rmps) {
        if (null == rmps) {
            return;
        }
        LOG.log(Level.FINE, "encoding RMPs in SOAP headers");
        try {
            Collection<AckRequestedType> requested;
            Collection<SequenceAcknowledgement> acks;
            Element header = (Element)message.getHeaders(Element.class);
            RMSoapInterceptor.discardRMHeaders(header);
            header.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + RMConstants.getNamespacePrefix(), RMConstants.getNamespace());
            Marshaller marshaller = RMSoapInterceptor.getJAXBContext().createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            SequenceType seq = rmps.getSequence();
            if (null != seq) {
                RMSoapInterceptor.encodeProperty(seq, RMConstants.getSequenceQName(), SequenceType.class, header, marshaller);
            }
            if (null != (acks = rmps.getAcks())) {
                for (SequenceAcknowledgement ack : acks) {
                    RMSoapInterceptor.encodeProperty(ack, RMConstants.getSequenceAckQName(), SequenceAcknowledgement.class, header, marshaller);
                }
            }
            if (null != (requested = rmps.getAcksRequested())) {
                for (AckRequestedType ar : requested) {
                    RMSoapInterceptor.encodeProperty(ar, RMConstants.getAckRequestedQName(), AckRequestedType.class, header, marshaller);
                }
            }
        }
        catch (SOAPException se) {
            LOG.log(Level.WARNING, "SOAP_HEADER_ENCODE_FAILURE_MSG", se);
        }
        catch (JAXBException je) {
            LOG.log(Level.WARNING, "SOAP_HEADER_ENCODE_FAILURE_MSG", je);
        }
    }

    void decode(SoapMessage message) {
        RMProperties rmps = this.unmarshalRMProperties(message);
        RMContextUtils.storeRMProperties((Message)message, rmps, false);
    }

    public RMProperties unmarshalRMProperties(SoapMessage message) {
        RMProperties rmps = new RMProperties();
        try {
            ArrayList<SequenceAcknowledgement> acks = new ArrayList<SequenceAcknowledgement>();
            ArrayList<AckRequestedType> requested = new ArrayList<AckRequestedType>();
            Element header = (Element)message.getHeaders(Element.class);
            if (header != null) {
                Unmarshaller unmarshaller = RMSoapInterceptor.getJAXBContext().createUnmarshaller();
                NodeList headerElements = header.getChildNodes();
                for (int i = 0; i < headerElements.getLength(); ++i) {
                    Node node = headerElements.item(i);
                    if (1 != node.getNodeType()) continue;
                    Element headerElement = (Element)headerElements.item(i);
                    String headerURI = headerElement.getNamespaceURI();
                    String localName = headerElement.getLocalName();
                    if (!RMConstants.getNamespace().equals(headerURI)) continue;
                    LOG.log(Level.FINE, "decoding RM header {0}", localName);
                    if (RMConstants.getSequenceName().equals(localName)) {
                        SequenceType s = RMSoapInterceptor.decodeProperty(SequenceType.class, headerElement, unmarshaller);
                        rmps.setSequence(s);
                        continue;
                    }
                    if (RMConstants.getSequenceAckName().equals(localName)) {
                        SequenceAcknowledgement ack = RMSoapInterceptor.decodeProperty(SequenceAcknowledgement.class, headerElement, unmarshaller);
                        acks.add(ack);
                        continue;
                    }
                    if (!RMConstants.getAckRequestedName().equals(localName)) continue;
                    AckRequestedType ar = RMSoapInterceptor.decodeProperty(AckRequestedType.class, headerElement, unmarshaller);
                    requested.add(ar);
                }
                if (acks.size() > 0) {
                    rmps.setAcks(acks);
                }
                if (requested.size() > 0) {
                    rmps.setAcksRequested(requested);
                }
            }
        }
        catch (JAXBException ex) {
            LOG.log(Level.WARNING, "SOAP_HEADER_DECODE_FAILURE_MSG", ex);
        }
        return rmps;
    }

    private static synchronized JAXBContext getJAXBContext() throws JAXBException {
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((String)WS_RM_PACKAGE);
        }
        return jaxbContext;
    }

    private static <T> void encodeProperty(T value, QName qname, Class<T> clz, Element header, Marshaller marshaller) throws JAXBException {
        if (value != null) {
            LOG.log(Level.FINE, "encoding " + value + " into RM header {0}", qname);
            marshaller.marshal((Object)new JAXBElement(qname, clz, value), (Node)header);
        }
    }

    public static <T> T decodeProperty(Class<T> clz, Element headerElement, Unmarshaller unmarshaller) throws JAXBException {
        if (null == unmarshaller) {
            unmarshaller = RMSoapInterceptor.getJAXBContext().createUnmarshaller();
        }
        JAXBElement element = unmarshaller.unmarshal((Node)headerElement, clz);
        return (T)element.getValue();
    }

    private static void discardRMHeaders(Element header) throws SOAPException {
        NodeList headerElements = header.getElementsByTagNameNS(RMConstants.getNamespace(), "*");
        for (int i = 0; i < headerElements.getLength(); ++i) {
            Node headerElement = headerElements.item(i);
            if (!RMConstants.getNamespace().equals(headerElement.getNamespaceURI())) continue;
            header.removeChild(headerElement);
        }
    }

    private void updateServiceModelInfo(SoapMessage message) {
        assert (!RMContextUtils.isOutbound((Message)message));
        AddressingPropertiesImpl maps = RMContextUtils.retrieveMAPs((Message)message, false, false);
        AttributedURIType actionURI = null == maps ? null : maps.getAction();
        String action = null == actionURI ? null : actionURI.getValue();
        LOG.fine("action: " + action);
        if (!(RMConstants.getCreateSequenceAction().equals(action) || RMConstants.getCreateSequenceResponseAction().equals(action) || RMConstants.getTerminateSequenceAction().equals(action) || RMConstants.getSequenceAckAction().equals(action) || RMConstants.getLastMessageAction().equals(action))) {
            return;
        }
        LOG.info("Updating service model info in exchange");
        RMManager manager = this.getManager(message);
        assert (manager != null);
        RMEndpoint rme = manager.getReliableEndpoint((Message)message);
        Exchange exchange = message.getExchange();
        exchange.put(Endpoint.class, (Object)rme.getEndpoint());
        exchange.put(Service.class, (Object)rme.getService());
        exchange.put(Binding.class, (Object)rme.getEndpoint().getBinding());
        BindingInfo bi = rme.getEndpoint().getEndpointInfo().getBinding();
        BindingOperationInfo boi = null;
        if (RMConstants.getCreateSequenceAction().equals(action) || RMConstants.getCreateSequenceResponseAction().equals(action)) {
            boi = bi.getOperation(RMConstants.getCreateSequenceOperationName());
        } else if (RMConstants.getSequenceAckAction().equals(action)) {
            boi = bi.getOperation(RMConstants.getSequenceAckOperationName());
        } else if (RMConstants.getTerminateSequenceAction().equals(action)) {
            boi = bi.getOperation(RMConstants.getTerminateSequenceOperationName());
        }
        assert (boi != null);
        exchange.put(BindingOperationInfo.class, (Object)boi);
        if (!RMConstants.getCreateSequenceResponseAction().equals(action)) {
            LOG.fine("Changing requestor role from " + message.get((Object)"org.apache.cxf.client") + " to false");
            Object originalRequestorRole = message.get((Object)"org.apache.cxf.client");
            if (null != originalRequestorRole) {
                message.put("org.apache.cxf.client.original", originalRequestorRole);
            }
            message.put("org.apache.cxf.client", (Object)Boolean.FALSE);
        }
        if (RMConstants.getSequenceAckAction().equals(action)) {
            exchange.setOneWay(true);
        }
    }

    private RMManager getManager(SoapMessage message) {
        InterceptorChain chain = message.getInterceptorChain();
        ListIterator it = chain.getIterator();
        while (it.hasNext()) {
            Interceptor i = (Interceptor)it.next();
            if (!(i instanceof AbstractRMInterceptor)) continue;
            return ((AbstractRMInterceptor)i).getManager();
        }
        return null;
    }

    static {
        LOG = LogUtils.getL7dLogger(RMSoapInterceptor.class);
        WS_RM_PACKAGE = PackageUtils.getPackageName(SequenceType.class);
    }
}

