/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.i18n.UncheckedException;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.DataReaderFactory;
import org.apache.cxf.databinding.DataWriterFactory;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxb.JAXBContextInitializer;
import org.apache.cxf.jaxb.JAXBDataReaderFactory;
import org.apache.cxf.jaxb.JAXBDataWriterFactory;
import org.apache.cxf.jaxb.JAXBSchemaInitializer;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.TypeInfo;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXBDataBinding
implements DataBinding {
    public static final String SCHEMA_RESOURCE = "SCHEMRESOURCE";
    private static final Logger LOG = Logger.getLogger(JAXBDataBinding.class.getName());
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXBDataBinding.class);
    JAXBDataReaderFactory reader = new JAXBDataReaderFactory();
    JAXBDataWriterFactory writer = new JAXBDataWriterFactory();
    JAXBContext context;
    Class cls;

    public JAXBDataBinding() {
    }

    public JAXBDataBinding(Class<?> ... classes) throws JAXBException {
        HashSet classSet = new HashSet();
        classSet.addAll(Arrays.asList(classes));
        this.setContext(JAXBDataBinding.createJAXBContext(classSet));
    }

    public JAXBDataBinding(JAXBContext context) {
        this();
        this.setContext(context);
    }

    public void setContext(JAXBContext ctx) {
        this.context = ctx;
        this.reader.setJAXBContext(this.context);
        this.writer.setJAXBContext(this.context);
    }

    public DataReaderFactory getDataReaderFactory() {
        return this.reader;
    }

    public DataWriterFactory getDataWriterFactory() {
        return this.writer;
    }

    public Map<String, SchemaInfo> getSchemas(ServiceInfo serviceInfo) {
        List schemaResources = CastUtils.cast((List)((List)serviceInfo.getProperty(SCHEMA_RESOURCE, List.class)), String.class);
        return this.loadSchemas(schemaResources);
    }

    private Map<String, SchemaInfo> loadSchemas(Collection<String> schemaResources) {
        HashMap<String, SchemaInfo> schemas = new HashMap<String, SchemaInfo>();
        for (String schema : schemaResources) {
            URIResolver resolver = null;
            try {
                resolver = new URIResolver(schema);
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, e.getMessage());
            }
            if (!resolver.isResolved()) {
                throw new UncheckedException(new Message("SCHEMA_NOT_RESOLVED", BUNDLE, new Object[]{schema}));
            }
            if (resolver.isFile()) {
                this.loadSchemaFromFile(schema, schemas);
                continue;
            }
            this.loadSchemaFromClassPath(schema, schemas);
        }
        return schemas;
    }

    private void loadSchemaFromClassPath(String schema, Map<String, SchemaInfo> schemas) {
    }

    private void loadSchemaFromFile(String schema, Map<String, SchemaInfo> schemas) {
        try {
            XmlSchemaCollection schemaCol = new XmlSchemaCollection();
            URIResolver resolver = new URIResolver(schema);
            schemaCol.setBaseUri(resolver.getFile().getParent());
            Document schemaDoc = DOMUtils.readXml((InputStream)resolver.getInputStream());
            XmlSchema xmlSchema = schemaCol.read(schemaDoc.getDocumentElement());
            SchemaInfo schemaInfo = new SchemaInfo(null, xmlSchema.getTargetNamespace());
            schemaInfo.setElement(schemaDoc.getDocumentElement());
            schemas.put(schemaInfo.getNamespaceURI(), schemaInfo);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage());
            throw new UncheckedException((Throwable)e);
        }
        catch (SAXException e) {
            LOG.log(Level.SEVERE, e.getMessage());
            throw new UncheckedException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOG.log(Level.SEVERE, e.getMessage());
            throw new UncheckedException((Throwable)e);
        }
    }

    public void initialize(ServiceInfo serviceInfo) {
        HashSet classes = new HashSet();
        JAXBContextInitializer initializer = new JAXBContextInitializer(serviceInfo, classes);
        initializer.walk();
        try {
            this.setContext(JAXBDataBinding.createJAXBContext(classes));
        }
        catch (JAXBException e1) {
            throw new ServiceConstructionException((Throwable)e1);
        }
        XmlSchemaCollection col = (XmlSchemaCollection)serviceInfo.getProperty(WSDLServiceBuilder.WSDL_SCHEMA_LIST);
        if (col != null) {
            return;
        }
        col = new XmlSchemaCollection();
        try {
            TypeInfo typeInfo = serviceInfo.getTypeInfo();
            if (typeInfo == null) {
                typeInfo = new TypeInfo(serviceInfo);
                serviceInfo.setTypeInfo(typeInfo);
            }
            for (DOMResult r : this.generateJaxbSchemas()) {
                Document d = (Document)r.getNode();
                String ns = d.getDocumentElement().getAttribute("targetNamespace");
                if (ns == null) {
                    ns = "";
                }
                if ("http://www.w3.org/2005/08/addressing/wsdl".equals(ns)) continue;
                SchemaInfo schema = new SchemaInfo(typeInfo, ns);
                schema.setElement(d.getDocumentElement());
                typeInfo.addSchema(schema);
                col.read(d.getDocumentElement());
            }
        }
        catch (IOException e) {
            throw new ServiceConstructionException(new Message("SCHEMA_GEN_EXC", BUNDLE, new Object[0]), (Throwable)e);
        }
        serviceInfo.setProperty(WSDLServiceBuilder.WSDL_SCHEMA_LIST, (Object)col);
        JAXBSchemaInitializer schemaInit = new JAXBSchemaInitializer(serviceInfo, col);
        schemaInit.walk();
    }

    private List<DOMResult> generateJaxbSchemas() throws IOException {
        final ArrayList<DOMResult> results = new ArrayList<DOMResult>();
        this.context.generateSchema(new SchemaOutputResolver(){

            public Result createOutput(String ns, String file) throws IOException {
                DOMResult result = new DOMResult();
                result.setSystemId(file);
                results.add(result);
                return result;
            }
        });
        return results;
    }

    public static JAXBContext createJAXBContext(Set<Class<?>> classes) throws JAXBException {
        Iterator<Class<?>> it = classes.iterator();
        String className = "";
        Class<?> remoteExceptionObject = null;
        while (it.hasNext()) {
            remoteExceptionObject = it.next();
            className = ((Object)remoteExceptionObject).toString();
            if ("".equals(className) || !className.contains("RemoteException")) continue;
            classes.remove(remoteExceptionObject);
        }
        try {
            classes.add(Class.forName("org.apache.cxf.ws.addressing.wsdl.AttributedQNameType"));
            classes.add(Class.forName("org.apache.cxf.ws.addressing.wsdl.ObjectFactory"));
            classes.add(Class.forName("org.apache.cxf.ws.addressing.wsdl.ServiceNameType"));
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        return JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()]));
    }
}

