/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb.attachment;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import org.apache.cxf.binding.attachment.AttachmentDeserializer;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;

public class JAXBAttachmentUnmarshaller
extends AttachmentUnmarshaller {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXBAttachmentUnmarshaller.class);
    private Message message;
    private AttachmentDeserializer ad;

    public JAXBAttachmentUnmarshaller(Message messageParam) {
        this.message = messageParam;
        this.ad = (AttachmentDeserializer)this.message.get(AttachmentDeserializer.class);
        if (this.ad == null) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_ATTACHMENT_DESERIALIZER", LOG, new Object[0]));
        }
    }

    public DataHandler getAttachmentAsDataHandler(String contentId) {
        return this.getAttachment(contentId).getDataHandler();
    }

    public byte[] getAttachmentAsByteArray(String contentId) {
        Attachment att = this.getAttachment(contentId);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            JAXBAttachmentUnmarshaller.copy(att.getDataHandler().getInputStream(), bos);
        }
        catch (IOException e) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("ATTACHMENT_READ_ERROR", LOG, new Object[0]), (Throwable)e);
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream input, OutputStream output) throws IOException {
        try {
            byte[] buffer = new byte[8096];
            int n = input.read(buffer);
            while (-1 != n) {
                output.write(buffer, 0, n);
                n = input.read(buffer);
            }
        }
        finally {
            output.close();
            input.close();
        }
    }

    public boolean isXOPPackage() {
        Attachment primaryMimePart = (Attachment)this.message.getContent(Attachment.class);
        if (primaryMimePart == null) {
            return false;
        }
        String contentTypeOfSoapBodyPart = primaryMimePart.getHeader(HttpHeaderHelper.getHeaderKey((String)"Content-Type"));
        if (contentTypeOfSoapBodyPart != null && contentTypeOfSoapBodyPart.indexOf("application/xop+xml") >= 0) {
            if (contentTypeOfSoapBodyPart.indexOf("application/soap+xml") >= 0) {
                return true;
            }
            if (contentTypeOfSoapBodyPart.indexOf("text/xml") >= 0) {
                return true;
            }
        }
        return false;
    }

    private Attachment getAttachment(String contentId) {
        Attachment att = null;
        try {
            att = this.ad.getAttachment(contentId);
        }
        catch (MessagingException me) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("FAILED_GETTING_ATTACHMENT", LOG, new Object[]{contentId}), (Throwable)me);
        }
        catch (IOException ioe) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("FAILED_GETTING_ATTACHMENT", LOG, new Object[]{contentId}), (Throwable)ioe);
        }
        if (att == null) {
            throw new IllegalArgumentException("Attachment " + contentId + " was not found.");
        }
        return att;
    }
}

