/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb.io;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.jaxb.JAXBDataReaderFactory;
import org.apache.cxf.service.model.MessagePartInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPBodyDataReader
implements DataReader<SOAPBody> {
    final JAXBDataReaderFactory factory;

    public SOAPBodyDataReader(JAXBDataReaderFactory cb) {
        this.factory = cb;
    }

    public Object read(SOAPBody input) {
        return null;
    }

    public Object read(MessagePartInfo part, SOAPBody input) {
        return null;
    }

    public Object read(QName name, SOAPBody input, Class type) {
        Source obj = null;
        SOAPBody src = input;
        try {
            Document doc = src.extractContentAsDocument();
            assert (doc != null);
            if (DOMSource.class.isAssignableFrom(type)) {
                obj = new DOMSource();
                obj.setNode(doc);
            } else if (SAXSource.class.isAssignableFrom(type)) {
                InputSource inputSource = new InputSource(XMLUtils.getInputStream((Document)doc));
                obj = new SAXSource(inputSource);
            } else if (StreamSource.class.isAssignableFrom(type) || Source.class.isAssignableFrom(type)) {
                obj = new StreamSource(XMLUtils.getInputStream((Document)doc));
            } else if (Object.class.isAssignableFrom(type)) {
                JAXBContext context = this.factory.getJAXBContext();
                Unmarshaller u = context.createUnmarshaller();
                return u.unmarshal((Node)doc);
            }
        }
        catch (Exception se) {
            se.printStackTrace();
        }
        return obj;
    }
}

