/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb.io;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.soap.SOAPBody;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.jaxb.JAXBDataWriterFactory;
import org.apache.cxf.service.model.MessagePartInfo;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPBodyDataWriter
implements DataWriter<SOAPBody> {
    protected SOAPBody dest;
    final JAXBDataWriterFactory factory;

    public SOAPBodyDataWriter(JAXBDataWriterFactory f) {
        this.factory = f;
    }

    public void write(Object obj, SOAPBody output) {
        this.dest = output;
        try {
            if (DOMSource.class.isAssignableFrom(obj.getClass())) {
                DOMSource domSource = (DOMSource)obj;
                this.dest.addDocument((Document)domSource.getNode());
            } else if (SAXSource.class.isAssignableFrom(obj.getClass())) {
                SAXSource saxSource = (SAXSource)obj;
                Document doc = XMLUtils.getParser().parse(saxSource.getInputSource());
                this.dest.addDocument(doc);
            } else if (StreamSource.class.isAssignableFrom(obj.getClass())) {
                StreamSource streamSource = (StreamSource)obj;
                Document doc = XMLUtils.getParser().parse(streamSource.getInputStream());
                this.dest.addDocument(doc);
            } else if (Object.class.isAssignableFrom(obj.getClass())) {
                JAXBContext context = this.factory.getJAXBContext();
                Marshaller u = context.createMarshaller();
                u.setProperty("jaxb.encoding", (Object)"UTF-8");
                u.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                u.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
                DOMResult domResult = new DOMResult();
                u.marshal(obj, (Result)domResult);
                this.dest.addDocument((Document)domResult.getNode());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void write(Object obj, MessagePartInfo part, SOAPBody output) {
    }
}

