/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.util.List;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.xml.stream.Location;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;

public abstract class AbstractValidator {
    protected List<String> errorMessages = new Vector<String>();
    protected Definition def;
    protected ToolContext env;

    public AbstractValidator() {
    }

    public AbstractValidator(Definition definition) {
        this.def = definition;
    }

    public AbstractValidator(String schemaDir) throws ToolException {
    }

    public AbstractValidator(Definition definition, ToolContext pEnv) {
        this.def = definition;
        this.env = pEnv;
    }

    public abstract boolean isValid();

    public void addErrorMessage(String err) {
        this.errorMessages.add(err);
    }

    public String getErrorMessage() {
        StringBuffer strbuffer = new StringBuffer();
        for (int i = 0; i < this.errorMessages.size(); ++i) {
            strbuffer.append(this.errorMessages.get(i));
            strbuffer.append(System.getProperty("line.separator"));
        }
        return strbuffer.toString();
    }

    public void addError(Location loc, String msg) {
        String errMsg = loc != null ? "line " + loc.getLineNumber() + " of " : "";
        errMsg = errMsg + this.def.getDocumentBaseURI() + " " + msg;
        this.addErrorMessage(errMsg);
    }
}

