/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.tools.validator.internal.LSInputImpl;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

class SchemaResourceResolver
implements LSResourceResolver {
    private static final Map<String, String> NSFILEMAP = new HashMap<String, String>();

    SchemaResourceResolver() {
    }

    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        LSInputImpl lsin = null;
        String resURL = null;
        String localFile = null;
        if (systemId != null) {
            String schemaLocation = "";
            if (baseURI != null) {
                schemaLocation = baseURI.substring(0, baseURI.lastIndexOf("/") + 1);
            }
            resURL = systemId.indexOf("http://") < 0 ? schemaLocation + systemId : systemId;
        } else if (namespaceURI != null) {
            resURL = namespaceURI;
        }
        if (resURL != null && resURL.startsWith("http://")) {
            String filename = NSFILEMAP.get(resURL);
            if (filename != null) {
                localFile = "schemas/wsdl/" + filename;
            } else {
                try {
                    URL url = new URL(resURL);
                    URLConnection urlCon = url.openConnection();
                    urlCon.setUseCaches(false);
                    lsin = new LSInputImpl();
                    lsin.setSystemId(resURL);
                    lsin.setByteStream(urlCon.getInputStream());
                }
                catch (Exception e) {
                    return null;
                }
            }
        } else if (resURL != null && !resURL.startsWith("http:")) {
            localFile = resURL;
        } else {
            return null;
        }
        try {
            URIResolver resolver = new URIResolver(localFile);
            if (resolver.isResolved()) {
                lsin = new LSInputImpl();
                lsin.setSystemId(localFile);
                lsin.setByteStream(resolver.getInputStream());
            }
        }
        catch (IOException e) {
            return null;
        }
        return lsin;
    }

    static {
        NSFILEMAP.put("http://www.w3.org/XML/1998/namespace", "xml.xsd");
        NSFILEMAP.put("http://schemas.xmlsoap.org/wsdl/", "wsdl.xsd");
        NSFILEMAP.put("http://www.w3.org/2001/XMLSchema", "XMLSchema.xsd");
    }
}

