/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap;

import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.AbstractWrappedMessage;
import org.apache.cxf.message.Message;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapMessage
extends AbstractWrappedMessage {
    private static final DocumentBuilder BUILDER = DOMUtils.createDocumentBuilder();
    private Map<Class<?>, Object> headers = new HashMap();
    private SoapVersion version = Soap11.getInstance();

    public SoapMessage(Message message) {
        super(message);
    }

    public SoapVersion getVersion() {
        return this.version;
    }

    public void setVersion(SoapVersion v) {
        this.version = v;
    }

    public <T> boolean hasHeaders(Class<T> format) {
        return this.headers.containsKey(format);
    }

    public <T> T getHeaders(Class<T> format) {
        T t = format.cast(this.headers.get(format));
        if (t == null && Element.class.equals(format)) {
            Document doc = BUILDER.newDocument();
            Element header = doc.createElementNS(this.version.getNamespace(), this.version.getHeader().getLocalPart());
            header.setPrefix(this.version.getPrefix());
            this.setHeaders(Element.class, header);
            t = format.cast(header);
        }
        return t;
    }

    public <T> void setHeaders(Class<T> format, T content) {
        this.headers.put(format, content);
    }

    public String getAttachmentMimeType() {
        return this.version.getSoapMimeType();
    }
}

