/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.ResourceBundle;
import org.apache.cxf.binding.attachment.AttachmentSerializer;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.AbstractCachedOutputStream;
import org.apache.cxf.message.Message;

public class AttachmentOutInterceptor
extends AbstractSoapInterceptor {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AttachmentOutInterceptor.class);

    public AttachmentOutInterceptor() {
        this.setPhase("pre-stream");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        if (!Boolean.TRUE.equals(message.getContextualProperty(Message.MTOM_ENABLED))) {
            return;
        }
        OutputStream os = (OutputStream)message.getContent(OutputStream.class);
        CachedStream cs = new CachedStream();
        message.setContent(OutputStream.class, (Object)cs);
        if (!message.getInterceptorChain().doIntercept((Message)message) && message.getContent(Exception.class) != null) {
            if (message.getContent(Exception.class) instanceof Fault) {
                throw (Fault)message.getContent(Exception.class);
            }
            throw new Fault((Throwable)message.getContent(Exception.class));
        }
        message.setContent(OutputStream.class, os);
        try {
            Collection attachments = message.getAttachments();
            cs.flush();
            if (attachments.size() > 0) {
                AttachmentSerializer as = new AttachmentSerializer((Message)message, cs.getInputStream(), os);
                as.serializeMultipartMessage();
            } else {
                os.flush();
                AbstractCachedOutputStream.copyStream((InputStream)cs.getInputStream(), (OutputStream)os, (int)65536);
            }
        }
        catch (IOException ioe) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("ATTACHMENT_IO", BUNDLE, new Object[]{ioe.toString()}), SoapFault.ATTACHMENT_IO);
        }
    }

    private class CachedStream
    extends AbstractCachedOutputStream {
        private CachedStream() {
        }

        protected void doFlush() throws IOException {
            this.currentStream.flush();
        }

        protected void doClose() throws IOException {
        }

        protected void onWrite() throws IOException {
        }
    }
}

