/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.util.logging.Logger;
import org.apache.cxf.binding.attachment.AttachmentDeserializer;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartMessageInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String ATTACHMENT_DIRECTORY = "attachment-directory";
    public static final String ATTACHMENT_MEMORY_THRESHOLD = "attachment-memory-threshold";
    public static final int THRESHHOLD = 102400;
    private static final Logger LOG = Logger.getLogger(MultipartMessageInterceptor.class.getName());

    public MultipartMessageInterceptor() {
        this.setPhase("receive");
    }

    public void handleMessage(Message message) {
        if (this.isGET(message)) {
            LOG.info("MultipartMessageInterceptor skipped in HTTP GET method");
            return;
        }
        AttachmentDeserializer ad = new AttachmentDeserializer(message);
        if (ad.preprocessMessage()) {
            message.put(AttachmentDeserializer.class, (Object)ad);
        }
    }

    public void handleFault(Message messageParam) {
    }
}

