/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.model.SoapBodyInfo;
import org.apache.cxf.binding.soap.model.SoapHeaderInfo;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.databinding.DataWriterFactory;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapOutInterceptor
extends AbstractSoapInterceptor {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(SoapOutInterceptor.class);

    public SoapOutInterceptor() {
        this.setPhase("write");
    }

    public void handleMessage(SoapMessage message) {
        SoapVersion soapVersion = message.getVersion();
        try {
            XMLStreamWriter xtw = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
            message.setContent(XMLStreamWriter.class, xtw);
            xtw.setPrefix(soapVersion.getPrefix(), soapVersion.getNamespace());
            xtw.writeStartElement(soapVersion.getPrefix(), soapVersion.getEnvelope().getLocalPart(), soapVersion.getNamespace());
            xtw.writeNamespace(soapVersion.getPrefix(), soapVersion.getNamespace());
            boolean preexistingHeaders = false;
            if (message.hasHeaders(Element.class)) {
                Element eleHeaders = message.getHeaders(Element.class);
                boolean bl = preexistingHeaders = eleHeaders != null && eleHeaders.hasChildNodes();
                if (preexistingHeaders) {
                    StaxUtils.writeElement((Element)eleHeaders, (XMLStreamWriter)xtw, (boolean)true, (boolean)false);
                }
            }
            boolean endedHeader = this.handleHeaderPart(preexistingHeaders, message);
            if (preexistingHeaders && !endedHeader) {
                xtw.writeEndElement();
            }
            xtw.writeStartElement(soapVersion.getPrefix(), soapVersion.getBody().getLocalPart(), soapVersion.getNamespace());
            message.getInterceptorChain().doInterceptInSubChain((Message)message);
            xtw.writeEndElement();
            xtw.writeEndElement();
            xtw.flush();
        }
        catch (XMLStreamException e) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("XML_WRITE_EXC", BUNDLE, new Object[0]), e, soapVersion.getSender());
        }
    }

    private boolean handleHeaderPart(boolean preexistingHeaders, SoapMessage message) {
        BindingMessageInfo bmi;
        boolean endedHeader = false;
        Exchange exchange = message.getExchange();
        BindingOperationInfo bop = (BindingOperationInfo)exchange.get((Object)BindingOperationInfo.class.getName());
        if (bop == null) {
            return endedHeader;
        }
        XMLStreamWriter xtw = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
        boolean startedHeader = false;
        List parts = new ArrayList();
        BindingMessageInfo bindingMessageInfo = bmi = this.isRequestor((Message)message) ? bop.getInput() : bop.getOutput();
        if (bmi == null) {
            return endedHeader;
        }
        parts = bmi.getMessageInfo().getMessageParts();
        if (parts.size() > 0) {
            List objs = (List)message.getContent(List.class);
            if (objs == null) {
                return endedHeader;
            }
            Object[] args = objs.toArray();
            SoapVersion soapVersion = message.getVersion();
            List headers = bmi.getExtensors(SoapHeaderInfo.class);
            if (headers == null) {
                return endedHeader;
            }
            for (SoapHeaderInfo header : headers) {
                Object arg = args[header.getSequence()];
                if (!startedHeader && !preexistingHeaders) {
                    try {
                        xtw.writeStartElement(soapVersion.getPrefix(), soapVersion.getHeader().getLocalPart(), soapVersion.getNamespace());
                    }
                    catch (XMLStreamException e) {
                        throw new SoapFault(new org.apache.cxf.common.i18n.Message("XML_WRITE_EXC", BUNDLE, new Object[0]), e, soapVersion.getSender());
                    }
                    startedHeader = true;
                }
                DataWriter<XMLStreamWriter> dataWriter = this.getDataWriter((Message)message);
                dataWriter.write(arg, header.getPart(), (Object)xtw);
            }
            for (MessagePartInfo part : parts) {
                if (bmi.getExtensor(SoapBodyInfo.class) == null || ((SoapBodyInfo)bmi.getExtensor(SoapBodyInfo.class)).getParts().contains(part)) continue;
                part.setProperty("SKIPPED", (Object)Boolean.TRUE);
            }
            if (startedHeader || preexistingHeaders) {
                try {
                    xtw.writeEndElement();
                    endedHeader = true;
                }
                catch (XMLStreamException e) {
                    throw new SoapFault(new org.apache.cxf.common.i18n.Message("XML_WRITE_EXC", BUNDLE, new Object[0]), e, soapVersion.getSender());
                }
            }
        }
        return endedHeader;
    }

    @Override
    protected boolean isRequestor(Message message) {
        return Boolean.TRUE.equals(message.containsKey((Object)"org.apache.cxf.client"));
    }

    protected DataWriter<XMLStreamWriter> getDataWriter(Message message) {
        Service service = ServiceModelUtil.getService((Exchange)message.getExchange());
        DataWriterFactory factory = service.getDataBinding().getDataWriterFactory();
        DataWriter dataWriter = null;
        for (Class cls : factory.getSupportedFormats()) {
            if (cls != XMLStreamWriter.class) continue;
            dataWriter = factory.createWriter(XMLStreamWriter.class);
            break;
        }
        if (dataWriter == null) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_DATAWRITER", BUNDLE, new Object[]{service.getName()}));
        }
        return dataWriter;
    }
}

