/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.util;

import com.sun.xml.bind.api.JAXBRIContext;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.JavaUtils;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.tools.common.DataBindingGenerator;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.URIParserUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ProcessorUtil {
    private static final String KEYWORDS_PREFIX = "_";

    private ProcessorUtil() {
    }

    public static String resolvePartName(Part part) {
        return ProcessorUtil.mangleNameToVariableName(part.getName());
    }

    public static String getPartType(Part part) {
        String typeName = part.getElementName() != null ? part.getElementName().getLocalPart() : (part.getTypeName() != null ? part.getTypeName().getLocalPart() : "BadType");
        return typeName;
    }

    public static String resolvePartType(Part part) {
        return ProcessorUtil.mangleNameToClassName(ProcessorUtil.getPartType(part));
    }

    public static String getType(Part part, ToolContext env, boolean fullname) {
        DataBindingGenerator dataBinder = (DataBindingGenerator)env.get("BindingGenerator");
        String type = dataBinder.getType(ProcessorUtil.getElementName(part), fullname);
        if (type == null) {
            type = ProcessorUtil.resolvePartType(part);
        }
        return type;
    }

    public static QName getElementName(Part part) {
        if (part == null) {
            return null;
        }
        QName elementName = part.getElementName();
        if (elementName == null) {
            elementName = part.getTypeName();
        }
        return elementName;
    }

    public static QName getMappedElementName(Part part, ToolContext env) {
        QName origin = ProcessorUtil.getElementName(part);
        if (origin == null) {
            return null;
        }
        if (!env.hasNamespace(origin.getNamespaceURI())) {
            return origin;
        }
        return new QName(env.getCustomizedNS(origin.getNamespaceURI()), origin.getLocalPart());
    }

    public static String resolvePartType(Part part, ToolContext env) {
        if (env != null) {
            return ProcessorUtil.resolvePartType(part, env, false);
        }
        return ProcessorUtil.resolvePartType(part);
    }

    public static String resolvePartType(Part part, ToolContext env, boolean fullName) {
        DataBindingGenerator binder = (DataBindingGenerator)env.get("BindingGenerator");
        if (binder == null) {
            String primitiveType = JAXBUtils.builtInTypeToJavaType((String)part.getTypeName().getLocalPart());
            if (part.getTypeName() != null && primitiveType != null) {
                return primitiveType;
            }
            return ProcessorUtil.resolvePartType(part);
        }
        String name = binder.getType(ProcessorUtil.getElementName(part), fullName);
        if (name == null) {
            return ProcessorUtil.resolvePartType(part);
        }
        return name;
    }

    public static String resolvePartNamespace(Part part) {
        QName qname = part.getElementName();
        if (qname == null) {
            qname = part.getTypeName();
        }
        if (qname != null) {
            return qname.getNamespaceURI();
        }
        return null;
    }

    public static String mangleNameToClassName(String clzName) {
        return JAXBRIContext.mangleNameToClassName((String)clzName);
    }

    public static String mangleNameToVariableName(String vName) {
        String result = JAXBRIContext.mangleNameToVariableName((String)vName);
        if (JavaUtils.isJavaKeyword((String)result)) {
            return KEYWORDS_PREFIX + result;
        }
        return result;
    }

    public static String parsePackageName(String namespace, String defaultPackageName) {
        String packageName;
        String string = packageName = defaultPackageName != null && defaultPackageName.trim().length() > 0 ? defaultPackageName : null;
        if (packageName == null) {
            packageName = URIParserUtil.getPackageName(namespace);
        }
        return packageName;
    }

    public static String getAbsolutePath(String location) throws IOException {
        if (location.startsWith("http://")) {
            return location;
        }
        return ProcessorUtil.resolvePath(new File(location).getCanonicalPath());
    }

    public static URL getWSDLURL(String location) throws Exception {
        if (location.startsWith("http://")) {
            return new URL(location);
        }
        return new File(ProcessorUtil.getAbsolutePath(location)).toURL();
    }

    private static String resolvePath(String path) {
        return path.replace('\\', '/');
    }

    public static URL[] pathToURLs(String path) {
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        URL[] urls = new URL[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            File file = new File(st.nextToken());
            URL url = null;
            try {
                url = file.toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (url == null) continue;
            urls[count++] = url;
        }
        if (urls.length != count) {
            URL[] tmp = new URL[count];
            System.arraycopy(urls, 0, tmp, 0, count);
            urls = tmp;
        }
        return urls;
    }

    public static String classNameToFilePath(String className) {
        if (className.indexOf(".") < 0) {
            return className;
        }
        String str = className.replaceAll("\\.", "/");
        return str;
    }

    public static String getFullClzName(Part part, ToolContext env, ClassCollector collector, boolean boxify) {
        DataBindingGenerator dataBindingGenerator = (DataBindingGenerator)env.get("BindingGenerator");
        String jtype = null;
        QName xmlTypeName = ProcessorUtil.getElementName(part);
        if (xmlTypeName == null) {
            xmlTypeName = part.getTypeName();
        }
        if (boxify && dataBindingGenerator != null) {
            jtype = dataBindingGenerator.getJavaType(xmlTypeName, true);
        }
        if (boxify && dataBindingGenerator == null) {
            Class holderClass = JAXBUtils.holderClass((String)xmlTypeName.getLocalPart());
            String string = jtype = holderClass == null ? null : holderClass.getName();
            if (jtype == null) {
                jtype = JAXBUtils.builtInTypeToJavaType((String)xmlTypeName.getLocalPart());
            }
        }
        if (!boxify && dataBindingGenerator != null) {
            jtype = dataBindingGenerator.getJavaType(xmlTypeName, false);
        }
        if (!boxify && dataBindingGenerator == null) {
            jtype = JAXBUtils.builtInTypeToJavaType((String)xmlTypeName.getLocalPart());
        }
        String namespace = xmlTypeName.getNamespaceURI();
        String type = ProcessorUtil.resolvePartType(part, env, true);
        String userPackage = env.mapPackageName(namespace);
        if (jtype == null) {
            jtype = collector.getTypesFullClassName(ProcessorUtil.parsePackageName(namespace, userPackage), type);
        }
        if (jtype == null) {
            jtype = !type.equals(ProcessorUtil.resolvePartType(part)) ? ProcessorUtil.resolvePartType(part, env, true) : ProcessorUtil.parsePackageName(namespace, userPackage) + "." + type;
        }
        return jtype;
    }

    public static String getFileOrURLName(String fileOrURL) {
        try {
            try {
                return ProcessorUtil.escapeSpace(new URL(fileOrURL).toExternalForm());
            }
            catch (MalformedURLException e) {
                return new File(fileOrURL).getCanonicalFile().toURL().toExternalForm();
            }
        }
        catch (Exception e) {
            return fileOrURL;
        }
    }

    private static String escapeSpace(String url) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < url.length(); ++i) {
            if (url.charAt(i) == ' ') {
                buf.append("%20");
                continue;
            }
            buf.append(url.charAt(i));
        }
        return buf.toString();
    }

    public static String absolutize(String name) {
        try {
            URL baseURL = new File(".").getCanonicalFile().toURL();
            return new URL(baseURL, name).toExternalForm();
        }
        catch (IOException iOException) {
            return name;
        }
    }

    public static String getHandlerConfigFileName(String name) {
        return name + "_handler";
    }

    public static boolean isWrapperStyle(Operation operation, ToolContext env) throws ToolException {
        QName outputElement;
        Message inputMessage = operation.getInput() == null ? null : operation.getInput().getMessage();
        Message outputMessage = operation.getOutput() == null ? null : operation.getOutput().getMessage();
        Map inputParts = new HashMap();
        Map outputParts = new HashMap();
        if (inputMessage != null) {
            inputParts = inputMessage.getParts();
        }
        if (outputMessage != null) {
            outputParts = outputMessage.getParts();
        }
        if (inputParts.size() > 1 || outputParts.size() > 1) {
            return false;
        }
        Part inputPart = null;
        if (inputParts.size() == 1 && (inputPart = (Part)inputParts.values().iterator().next()) != null) {
            QName inputElement = inputPart.getElementName();
            if (inputElement == null) {
                return false;
            }
            if (!operation.getName().equals(inputElement.getLocalPart())) {
                return false;
            }
        }
        Part outputPart = null;
        if (outputParts.size() == 1 && (outputPart = (Part)outputParts.values().iterator().next()) != null && (outputElement = outputPart.getElementName()) == null) {
            return false;
        }
        DataBindingGenerator databinder = (DataBindingGenerator)env.get("BindingGenerator");
        return databinder.getBlock(inputPart) != null && databinder.getBlock(outputPart) != null;
    }

    public static Node cloneNode(Document document, Node node, boolean deep) throws DOMException {
        Node clone;
        if (document == null || node == null) {
            return null;
        }
        short type = node.getNodeType();
        if (node.getOwnerDocument() == document) {
            return node.cloneNode(deep);
        }
        switch (type) {
            case 4: {
                clone = document.createCDATASection(node.getNodeValue());
                break;
            }
            case 8: {
                clone = document.createComment(node.getNodeValue());
                break;
            }
            case 5: {
                clone = document.createEntityReference(node.getNodeName());
                break;
            }
            case 1: {
                clone = document.createElement(node.getNodeName());
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    ((Element)clone).setAttribute(attributes.item(i).getNodeName(), attributes.item(i).getNodeValue());
                }
                break;
            }
            case 3: {
                clone = document.createTextNode(node.getNodeValue());
                break;
            }
            default: {
                return null;
            }
        }
        if (deep && type == 1) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                clone.appendChild(ProcessorUtil.cloneNode(document, child, true));
            }
        }
        return clone;
    }
}

