/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.util;

import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.cxf.tools.common.ToolConstants;
import org.apache.cxf.tools.common.extensions.jaxws.JAXWSBinding;
import org.apache.cxf.tools.common.extensions.jaxws.JAXWSBindingDeserializer;
import org.apache.cxf.tools.common.extensions.jaxws.JAXWSBindingSerializer;
import org.apache.cxf.tools.common.extensions.jms.JMSAddress;
import org.apache.cxf.tools.common.extensions.jms.JMSAddressSerializer;
import org.apache.cxf.tools.common.extensions.xmlformat.XMLFormat;
import org.apache.cxf.tools.common.extensions.xmlformat.XMLFormatBinding;
import org.apache.cxf.tools.common.extensions.xmlformat.XMLFormatBindingSerializer;
import org.apache.cxf.tools.common.extensions.xmlformat.XMLFormatSerializer;
import org.apache.cxf.tools.common.extensions.xmlformat.XMLHttpAddress;
import org.apache.cxf.tools.common.extensions.xmlformat.XMLHttpSerializer;

public class WSDLExtensionRegister {
    private WSDLFactory wsdlFactory;
    private WSDLReader wsdlreader;

    public WSDLExtensionRegister(WSDLFactory factory, WSDLReader reader) {
        this.wsdlFactory = factory;
        this.wsdlreader = reader;
    }

    public void registerExtensions() {
        ExtensionRegistry registry = this.wsdlreader.getExtensionRegistry();
        if (registry == null) {
            registry = this.wsdlFactory.newPopulatedExtensionRegistry();
        }
        this.registerJAXWSBinding(registry, Definition.class);
        this.registerJAXWSBinding(registry, PortType.class);
        this.registerJAXWSBinding(registry, Operation.class);
        this.registerJAXWSBinding(registry, Binding.class);
        this.registerJAXWSBinding(registry, BindingOperation.class);
        this.registerJMSAddress(registry, Port.class);
        this.registerXMLFormat(registry, BindingInput.class);
        this.registerXMLFormat(registry, BindingOutput.class);
        this.registerXMLFormatBinding(registry, Binding.class);
        this.registerXMLHttpAddress(registry, Port.class);
        this.wsdlreader.setExtensionRegistry(registry);
    }

    private void registerXMLFormat(ExtensionRegistry registry, Class clz) {
        registry.registerSerializer(clz, ToolConstants.XML_FORMAT, (ExtensionSerializer)new XMLFormatSerializer());
        registry.registerDeserializer(clz, ToolConstants.XML_FORMAT, (ExtensionDeserializer)new XMLFormatSerializer());
        registry.mapExtensionTypes(clz, ToolConstants.XML_FORMAT, XMLFormat.class);
    }

    private void registerXMLFormatBinding(ExtensionRegistry registry, Class clz) {
        registry.registerSerializer(clz, ToolConstants.XML_BINDING_FORMAT, (ExtensionSerializer)new XMLFormatBindingSerializer());
        registry.registerDeserializer(clz, ToolConstants.XML_BINDING_FORMAT, (ExtensionDeserializer)new XMLFormatBindingSerializer());
        registry.mapExtensionTypes(clz, ToolConstants.XML_BINDING_FORMAT, XMLFormatBinding.class);
    }

    private void registerXMLHttpAddress(ExtensionRegistry registry, Class clz) {
        registry.registerSerializer(clz, ToolConstants.XML_HTTP_ADDRESS, (ExtensionSerializer)new XMLHttpSerializer());
        registry.registerDeserializer(clz, ToolConstants.XML_HTTP_ADDRESS, (ExtensionDeserializer)new XMLHttpSerializer());
        registry.mapExtensionTypes(clz, ToolConstants.XML_HTTP_ADDRESS, XMLHttpAddress.class);
    }

    private void registerJMSAddress(ExtensionRegistry registry, Class clz) {
        registry.registerSerializer(clz, ToolConstants.JMS_ADDRESS, (ExtensionSerializer)new JMSAddressSerializer());
        registry.registerDeserializer(clz, ToolConstants.JMS_ADDRESS, (ExtensionDeserializer)new JMSAddressSerializer());
        registry.mapExtensionTypes(clz, ToolConstants.JMS_ADDRESS, JMSAddress.class);
    }

    private void registerJAXWSBinding(ExtensionRegistry registry, Class clz) {
        registry.registerSerializer(clz, ToolConstants.JAXWS_BINDINGS, (ExtensionSerializer)new JAXWSBindingSerializer());
        registry.registerDeserializer(clz, ToolConstants.JAXWS_BINDINGS, (ExtensionDeserializer)new JAXWSBindingDeserializer());
        registry.mapExtensionTypes(clz, ToolConstants.JAXWS_BINDINGS, JAXWSBinding.class);
    }
}

