/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdl2java.frontend.jaxws;

import java.util.Map;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaExceptionClass;
import org.apache.cxf.tools.common.model.JavaField;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.util.ProcessorUtil;
import org.apache.cxf.tools.wsdl2java.frontend.jaxws.AbstractGenerator;

public class FaultGenerator
extends AbstractGenerator {
    private static final String FAULT_TEMPLATE = "org/apache/cxf/tools/wsdl2java/frontend/jaxws/template/fault.vm";

    public FaultGenerator() {
        this.name = "fault.generator";
    }

    public boolean passthrough() {
        if (this.env.optionSet("genTypes") || this.env.optionSet("all")) {
            return false;
        }
        return this.env.optionSet("genAnt") || this.env.optionSet("genClient") || this.env.optionSet("genImpl") || this.env.optionSet("genSEI") || this.env.optionSet("genServer") || this.env.optionSet("genService");
    }

    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        JavaModel javaModel = this.env.getJavaModel();
        if (this.passthrough()) {
            return;
        }
        Map exceptionClasses = javaModel.getExceptionClasses();
        for (String expClassName : exceptionClasses.keySet()) {
            JavaExceptionClass expClz = (JavaExceptionClass)exceptionClasses.get(expClassName);
            this.clearAttributes();
            this.setAttributes("expClass", expClz);
            for (JavaField jf : expClz.getFields()) {
                this.setAttributes("paraName", ProcessorUtil.mangleNameToVariableName((String)jf.getName()));
            }
            this.setCommonAttributes();
            this.doWrite(FAULT_TEMPLATE, this.parseOutputName(expClz.getPackageName(), expClz.getName()));
        }
    }
}

