/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdl2java.processor.internal;

import com.sun.codemodel.JType;
import com.sun.tools.xjc.api.Property;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.WSDLConstants;
import org.apache.cxf.tools.common.model.JavaAnnotation;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.JavaReturn;
import org.apache.cxf.tools.common.model.JavaType;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.ProcessorUtil;
import org.apache.cxf.tools.wsdl2java.processor.internal.AbstractProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterProcessor
extends AbstractProcessor {
    private Map<String, Element> wsdlElementMap = new HashMap<String, Element>();
    private Map<String, String> wsdlLoc = new HashMap<String, String>();

    public ParameterProcessor(ToolContext penv) {
        super(penv);
        Definition definition = (Definition)penv.get("wsdlDefinition");
        this.wsdlLoc.put(definition.getTargetNamespace(), definition.getDocumentBaseURI());
        List defs = (List)penv.get("importedDefinition");
        for (Definition def : defs) {
            this.wsdlLoc.put(def.getTargetNamespace(), def.getDocumentBaseURI());
        }
    }

    public void process(JavaMethod method, Message inputMessage, Message outputMessage, boolean isRequestResponse, List<String> parameterOrder) throws ToolException {
        boolean parameterOrderPresent = false;
        if (parameterOrder != null && !parameterOrder.isEmpty()) {
            parameterOrderPresent = true;
        }
        if (parameterOrderPresent && this.isValidOrdering(parameterOrder, inputMessage, outputMessage) && !method.isWrapperStyle()) {
            this.buildParamModelsWithOrdering(method, inputMessage, outputMessage, isRequestResponse, parameterOrder);
        } else {
            this.buildParamModelsWithoutOrdering(method, inputMessage, outputMessage, isRequestResponse);
        }
    }

    public JavaParameter addParameterFromBinding(JavaMethod method, Part part, JavaType.Style style) throws ToolException {
        return this.addParameter(method, this.getParameterFromPart(method, part, style));
    }

    private JavaParameter getParameterFromPart(JavaMethod method, Part part, JavaType.Style style) {
        String name = ProcessorUtil.resolvePartName((Part)part);
        String namespace = ProcessorUtil.resolvePartNamespace((Part)part);
        String type = ProcessorUtil.resolvePartType((Part)part, (ToolContext)this.env);
        JavaParameter parameter = new JavaParameter(name, type, namespace);
        parameter.setPartName(part.getName());
        parameter.setQName(ProcessorUtil.getElementName((Part)part));
        parameter.setClassName(ProcessorUtil.getFullClzName((Part)part, (ToolContext)this.env, (ClassCollector)this.collector, (boolean)false));
        if (style == JavaType.Style.INOUT || style == JavaType.Style.OUT) {
            parameter.setHolder(true);
            parameter.setHolderName(Holder.class.getName());
            parameter.setHolderClass(ProcessorUtil.getFullClzName((Part)part, (ToolContext)this.env, (ClassCollector)this.collector, (boolean)true));
        }
        parameter.setStyle(style);
        return parameter;
    }

    private JavaParameter addParameter(JavaMethod method, JavaParameter parameter) throws ToolException {
        JavaAnnotation webParamAnnotation = new JavaAnnotation("WebParam");
        String name = parameter.getName();
        String targetNamespace = method.getInterface().getNamespace();
        String partName = null;
        if (method.getSoapStyle() == SOAPBinding.Style.DOCUMENT) {
            targetNamespace = parameter.getTargetNamespace();
            if (parameter.getQName() != null) {
                name = parameter.getQName().getLocalPart();
            }
            if (!method.isWrapperStyle()) {
                partName = parameter.getPartName();
            }
        }
        if (method.getSoapStyle() == SOAPBinding.Style.RPC) {
            name = parameter.getPartName();
            partName = parameter.getPartName();
        }
        if (partName != null) {
            webParamAnnotation.addArgument("partName", partName);
        }
        if (parameter.getStyle() == JavaType.Style.OUT || parameter.getStyle() == JavaType.Style.INOUT) {
            webParamAnnotation.addArgument("mode", "Mode." + parameter.getStyle().toString(), "");
        }
        webParamAnnotation.addArgument("name", name);
        if (method.getSoapStyle() == SOAPBinding.Style.DOCUMENT) {
            webParamAnnotation.addArgument("targetNamespace", targetNamespace);
        }
        parameter.setAnnotation(webParamAnnotation);
        method.addParameter(parameter);
        return parameter;
    }

    private void processReturn(JavaMethod method, Part part) {
        String name = part == null ? "return" : part.getName();
        String type = part == null ? "void" : ProcessorUtil.resolvePartType((Part)part, (ToolContext)this.env);
        String namespace = part == null ? null : ProcessorUtil.resolvePartNamespace((Part)part);
        JavaReturn returnType = new JavaReturn(name, type, namespace);
        returnType.setQName(ProcessorUtil.getElementName((Part)part));
        returnType.setStyle(JavaType.Style.OUT);
        if (namespace != null && type != null && !"void".equals(type)) {
            returnType.setClassName(ProcessorUtil.getFullClzName((Part)part, (ToolContext)this.env, (ClassCollector)this.collector, (boolean)false));
        }
        method.setReturn(returnType);
    }

    private void processInput(JavaMethod method, Message inputMessage) throws ToolException {
        List<Part> inputParts = this.getDefaultOrderParts(inputMessage);
        for (Part part : inputParts) {
            this.addParameter(method, this.getParameterFromPart(method, part, JavaType.Style.IN));
        }
    }

    private List<Part> getDefaultOrderParts(Message message) {
        Map partsMap = message.getParts();
        ArrayList<Part> parts = new ArrayList();
        if (message.getParts().size() > 1) {
            List<String> paraOrder = this.getDefaultOrderPartNameList(message);
            parts = message.getOrderedParts(paraOrder);
        } else {
            Collection partsValues = partsMap.values();
            for (Part part : partsValues) {
                parts.add(part);
            }
        }
        return parts;
    }

    private Element getWSDLElement(Message message) {
        String ns = message.getQName().getNamespaceURI();
        String wsdlLocation = this.wsdlLoc.get(ns);
        Element wsdlElement = this.wsdlElementMap.get(ns);
        if (this.wsdlElementMap.get(ns) == null) {
            Document doc = null;
            try {
                doc = DOMUtils.createDocumentBuilder().parse(wsdlLocation);
                wsdlElement = doc.getDocumentElement();
                this.wsdlElementMap.put(ns, wsdlElement);
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return wsdlElement;
    }

    private List<String> getDefaultOrderPartNameList(Message message) {
        ArrayList<String> nameList = new ArrayList<String>();
        Element wsdlElement = this.getWSDLElement(message);
        NodeList messageNodeList = wsdlElement.getElementsByTagNameNS(message.getQName().getNamespaceURI(), WSDLConstants.QNAME_MESSAGE.getLocalPart());
        Node messageNode = null;
        for (int i = 0; i < messageNodeList.getLength(); ++i) {
            Node node = messageNodeList.item(i);
            if (!DOMUtils.getAttribute((Node)node, (String)"name").equals(message.getQName().getLocalPart())) continue;
            messageNode = node;
            break;
        }
        if (messageNode == null) {
            return null;
        }
        Node partNode = DOMUtils.getChild(messageNode, (int)1);
        nameList.add(DOMUtils.getAttribute((Node)partNode, (String)"name"));
        while (partNode.getNextSibling() != null) {
            if ((partNode = partNode.getNextSibling()).getNodeType() != 1) continue;
            nameList.add(DOMUtils.getAttribute((Node)partNode, (String)"name"));
        }
        return nameList;
    }

    private void processWrappedInput(JavaMethod method, Message inputMessage) throws ToolException {
        Map inputPartsMap = inputMessage.getParts();
        Collection inputParts = inputPartsMap.values();
        if (inputParts.size() > 1) {
            this.processInput(method, inputMessage);
            return;
        }
        if (inputParts.isEmpty()) {
            return;
        }
        Part part = (Part)inputParts.iterator().next();
        List block = this.dataBinder.getBlock(part);
        if (block != null) {
            if (block.size() == 0) {
                // empty if block
            }
            for (Property item : block) {
                this.addParameter(method, this.getParameterFromProperty(item, JavaType.Style.IN, part));
            }
        }
    }

    private void processOutput(JavaMethod method, Message inputMessage, Message outputMessage, boolean isRequestResponse) throws ToolException {
        Map inputPartsMap = inputMessage == null ? new HashMap() : inputMessage.getParts();
        List<Object> outputParts = outputMessage == null ? new ArrayList() : this.getDefaultOrderParts(outputMessage);
        ArrayList<Part> outParts = new ArrayList<Part>();
        if (isRequestResponse) {
            for (Part part : outputParts) {
                Part inpart = (Part)inputPartsMap.get(part.getName());
                if (inpart == null) {
                    outParts.add(part);
                    continue;
                }
                if (this.isSamePart(inpart, part)) {
                    this.addParameter(method, this.getParameterFromPart(method, part, JavaType.Style.INOUT));
                    continue;
                }
                if (this.isSamePart(inpart, part)) continue;
                outParts.add(part);
            }
        }
        if (isRequestResponse && outParts.size() == 1) {
            this.processReturn(method, (Part)outParts.get(0));
            return;
        }
        this.processReturn(method, null);
        if (isRequestResponse) {
            for (Part part : outParts) {
                this.addParameter(method, this.getParameterFromPart(method, part, JavaType.Style.OUT));
            }
        }
    }

    private void processWrappedOutput(JavaMethod method, Message inputMessage, Message outputMessage, boolean isRequestResponse) throws ToolException {
        Map inputPartsMap = inputMessage == null ? new HashMap() : inputMessage.getParts();
        Map outputPartsMap = outputMessage == null ? new HashMap() : outputMessage.getParts();
        Collection outputParts = outputPartsMap.values();
        Collection inputParts = inputPartsMap.values();
        if (inputPartsMap.size() > 1 || outputPartsMap.size() > 1) {
            this.processOutput(method, inputMessage, outputMessage, isRequestResponse);
            return;
        }
        if (outputParts.size() == 0) {
            this.addVoidReturn(method);
            return;
        }
        Part inputPart = inputParts.size() > 0 ? (Part)inputParts.iterator().next() : null;
        Part outputPart = outputParts.size() > 0 ? (Part)outputParts.iterator().next() : null;
        List inputBlock = null;
        List outputBlock = null;
        if (inputPart != null) {
            inputBlock = this.dataBinder.getBlock(inputPart);
        }
        if (outputPart != null) {
            outputBlock = this.dataBinder.getBlock(outputPart);
        }
        if (outputBlock == null || outputBlock.size() == 0) {
            this.addVoidReturn(method);
            return;
        }
        method.setReturn(null);
        if (outputBlock.size() == 1 && inputBlock != null) {
            Property outElement = (Property)outputBlock.iterator().next();
            boolean sameWrapperChild = false;
            for (Property inElement : inputBlock) {
                if (!this.isSameWrapperChild(inElement, outElement)) continue;
                this.addParameter(method, this.getParameterFromProperty(outElement, JavaType.Style.INOUT, outputPart));
                sameWrapperChild = true;
                if (method.getReturn() != null) break;
                this.addVoidReturn(method);
                break;
            }
            if (!sameWrapperChild) {
                method.setReturn(this.getReturnFromProperty(outElement, outputPart));
                return;
            }
        }
        for (Property outElement : outputBlock) {
            if ("return".equals(outElement.elementName().getLocalPart())) {
                if (method.getReturn() != null) {
                    org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("WRAPPER_STYLE_TWO_RETURN_TYPES", LOG, new Object[0]);
                    throw new ToolException(msg);
                }
                method.setReturn(this.getReturnFromProperty(outElement, outputPart));
                continue;
            }
            boolean sameWrapperChild = false;
            if (inputBlock != null) {
                for (Property inElement : inputBlock) {
                    if (!this.isSameWrapperChild(inElement, outElement)) continue;
                    this.addParameter(method, this.getParameterFromProperty(outElement, JavaType.Style.INOUT, outputPart));
                    sameWrapperChild = true;
                    break;
                }
            }
            if (sameWrapperChild) continue;
            this.addParameter(method, this.getParameterFromProperty(outElement, JavaType.Style.OUT, outputPart));
        }
        if (method.getReturn() == null) {
            this.addVoidReturn(method);
        }
    }

    private void addVoidReturn(JavaMethod method) {
        JavaReturn returnType = new JavaReturn("return", "void", null);
        method.setReturn(returnType);
    }

    private boolean isSameWrapperChild(Property in, Property out) {
        if (!in.name().equals(out.name())) {
            return false;
        }
        if (!in.type().fullName().equals(out.type().fullName())) {
            return false;
        }
        return in.elementName().getNamespaceURI().equals(out.elementName().getNamespaceURI());
    }

    private JavaParameter getParameterFromProperty(Property property, JavaType.Style style, Part part) {
        JType t = property.type();
        String targetNamespace = ProcessorUtil.resolvePartNamespace((Part)part);
        if (targetNamespace == null) {
            targetNamespace = property.elementName().getNamespaceURI();
        }
        JavaParameter parameter = new JavaParameter(property.name(), t.fullName(), targetNamespace);
        parameter.setStyle(style);
        parameter.setQName(property.elementName());
        if (style == JavaType.Style.OUT || style == JavaType.Style.INOUT) {
            parameter.setHolder(true);
            parameter.setHolderName(Holder.class.getName());
            parameter.setHolderClass(t.boxify().fullName());
        }
        return parameter;
    }

    private JavaReturn getReturnFromProperty(Property property, Part part) {
        JType t = property.type();
        String targetNamespace = ProcessorUtil.resolvePartNamespace((Part)part);
        if (targetNamespace == null) {
            targetNamespace = property.elementName().getNamespaceURI();
        }
        JavaReturn returnType = new JavaReturn(property.name(), t.fullName(), targetNamespace);
        returnType.setQName(property.elementName());
        returnType.setStyle(JavaType.Style.OUT);
        return returnType;
    }

    private void buildParamModelsWithoutOrdering(JavaMethod method, Message inputMessage, Message outputMessage, boolean isRequestResponse) throws ToolException {
        if (inputMessage != null) {
            if (method.isWrapperStyle()) {
                this.processWrappedInput(method, inputMessage);
            } else {
                this.processInput(method, inputMessage);
            }
        }
        if (outputMessage == null) {
            this.processReturn(method, null);
        } else if (method.isWrapperStyle()) {
            this.processWrappedOutput(method, inputMessage, outputMessage, isRequestResponse);
        } else {
            this.processOutput(method, inputMessage, outputMessage, isRequestResponse);
        }
    }

    private void buildParamModelsWithOrdering(JavaMethod method, Message inputMessage, Message outputMessage, boolean isRequestResponse, List<String> parameterList) throws ToolException {
        Map inputPartsMap = inputMessage == null ? new HashMap() : inputMessage.getParts();
        Map outputPartsMap = outputMessage == null ? new HashMap() : outputMessage.getParts();
        Collection inputParts = inputPartsMap.values();
        Collection outputParts = outputPartsMap.values();
        ArrayList<Part> inputUnlistedParts = new ArrayList<Part>();
        ArrayList<Part> outputUnlistedParts = new ArrayList<Part>();
        for (Part part : inputParts) {
            if (parameterList.contains(part.getName())) continue;
            inputUnlistedParts.add(part);
        }
        if (isRequestResponse) {
            for (Part part : outputParts) {
                Part inpart;
                if (parameterList.contains(part.getName()) || (inpart = inputMessage.getPart(part.getName())) != null && (inpart == null || this.isSamePart(inpart, part))) continue;
                outputUnlistedParts.add(part);
            }
            if (outputUnlistedParts.size() == 1) {
                this.processReturn(method, (Part)outputUnlistedParts.get(0));
                outputPartsMap.remove(outputUnlistedParts.get(0));
                outputUnlistedParts.clear();
            } else {
                this.processReturn(method, null);
            }
        }
        int size = parameterList.size();
        for (int index = 0; index < size; ++index) {
            String partName = parameterList.get(index);
            Part part = (Part)inputPartsMap.get(partName);
            JavaType.Style style = JavaType.Style.IN;
            if (part == null) {
                part = (Part)outputPartsMap.get(partName);
                style = JavaType.Style.OUT;
            } else if (outputPartsMap.get(partName) != null && this.isSamePart(part, (Part)outputPartsMap.get(partName))) {
                style = JavaType.Style.INOUT;
            }
            if (part == null) continue;
            this.addParameter(method, this.getParameterFromPart(method, part, style));
        }
        for (Part part : inputUnlistedParts) {
            this.addParameter(method, this.getParameterFromPart(method, part, JavaType.Style.IN));
        }
        for (Part part : outputUnlistedParts) {
            this.addParameter(method, this.getParameterFromPart(method, part, JavaType.Style.INOUT));
        }
    }

    private boolean isSamePart(Part part1, Part part2) {
        QName qname1 = part1.getElementName();
        QName qname2 = part2.getElementName();
        if (qname1 != null && qname2 != null) {
            return qname1.equals(qname2);
        }
        qname1 = part1.getTypeName();
        qname2 = part2.getTypeName();
        if (qname1 != null && qname2 != null) {
            return qname1.equals(qname2);
        }
        return false;
    }

    private boolean isValidOrdering(List<String> parameterOrder, Message inputMessage, Message outputMessage) {
        Iterator<String> params = parameterOrder.iterator();
        Collection inputParts = inputMessage.getParts().values();
        Collection outputParts = outputMessage.getParts().values();
        boolean partFound = false;
        while (params.hasNext()) {
            String param = params.next();
            partFound = false;
            for (Part part : inputParts) {
                if (!param.equals(part.getName())) continue;
                partFound = true;
                break;
            }
            if (!partFound) {
                for (Part part : outputParts) {
                    if (!param.equals(part.getName())) continue;
                    partFound = true;
                    break;
                }
            }
            if (partFound) continue;
            break;
        }
        return partFound;
    }
}

