/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xjc.cfg;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.configuration.AbstractConfigurableBeanBase;
import org.xml.sax.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableBeansPlugin
extends Plugin {
    private static final String CFG_NAMESPACE_URI = "http://cxf.apache.org/configuration/cfg";
    private static final String CFG_CONFIGURABLE_ELEM_NAME = "configurable";

    public String getOptionName() {
        return "Xcfg";
    }

    public String getUsage() {
        return "-Xcfg: Generate configurable beans.";
    }

    public List<String> getCustomizationURIs() {
        return Collections.singletonList(CFG_NAMESPACE_URI);
    }

    public boolean isCustomizationTagName(String nsUri, String localName) {
        return nsUri.equals(CFG_NAMESPACE_URI) && localName.equals(CFG_CONFIGURABLE_ELEM_NAME);
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        for (ClassOutline co : outline.getClasses()) {
            CPluginCustomization cust = co.target.getCustomizations().find(CFG_NAMESPACE_URI, CFG_CONFIGURABLE_ELEM_NAME);
            if (null == cust) continue;
            cust.markAsAcknowledged();
            JDefinedClass dc = co.implClass;
            dc._extends(AbstractConfigurableBeanBase.class);
            this.updateGetters(co, dc);
            this.updateSetters(co, dc);
        }
        return true;
    }

    private void updateGetters(ClassOutline co, JDefinedClass dc) {
        for (FieldOutline fo : co.getDeclaredFields()) {
            String fieldName = fo.getPropertyInfo().getName(false);
            JType type = fo.getRawType();
            String typeName = type.fullName();
            String getterName = ("java.lang.Boolean".equals(typeName) ? "is" : "get") + fo.getPropertyInfo().getName(true);
            JMethod method = dc.getMethod(getterName, new JType[0]);
            JDocComment doc = method.javadoc();
            int mods = method.mods().getValue();
            JType mtype = method.type();
            JBlock block = method.body();
            dc.methods().remove(method);
            method = dc.method(mods, mtype, getterName);
            method.javadoc().append((Object)doc);
            JFieldRef fr = JExpr.ref((String)fieldName);
            JInvocation invocation = JExpr.invoke((String)"tryOverwrite");
            invocation.arg(JExpr.dotclass((JClass)type.boxify()));
            invocation.arg(JExpr.lit((String)fieldName));
            JVar tmp = method.body().decl((JType)type.boxify(), "_" + fieldName, (JExpression)invocation);
            JExpression test = JOp.not((JExpression)JOp.eq((JExpression)JExpr._null(), (JExpression)tmp));
            JConditional jc = method.body()._if(test);
            jc._then()._return((JExpression)tmp);
            test = JOp.not((JExpression)JOp.eq((JExpression)JExpr._null(), (JExpression)fr));
            jc = method.body()._if(test);
            jc._then()._return((JExpression)fr);
            invocation = JExpr.invoke((String)"tryFallback");
            invocation.arg(JExpr.dotclass((JClass)type.boxify()));
            invocation.arg(JExpr.lit((String)fieldName));
            method.body().assign((JAssignmentTarget)tmp, (JExpression)invocation);
            test = JOp.not((JExpression)JOp.eq((JExpression)JExpr._null(), (JExpression)tmp));
            jc = method.body()._if(test);
            jc._then()._return((JExpression)tmp);
            method.body().add((JStatement)block);
        }
    }

    private void updateSetters(ClassOutline co, JDefinedClass dc) {
        for (FieldOutline fo : co.getDeclaredFields()) {
            String fieldName = fo.getPropertyInfo().getName(false);
            JType type = fo.getRawType();
            String setterName = "set" + fo.getPropertyInfo().getName(true);
            JMethod method = dc.getMethod(setterName, new JType[]{type.boxify()});
            if (null == method) continue;
            JInvocation invocation = JExpr.invoke((String)"notifyPropertyChange");
            invocation.arg(JExpr.lit((String)fieldName));
            method.body().add((JStatement)invocation);
        }
    }
}

