/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.io.AbstractWrappedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.http.JettyHTTPServerEngine;
import org.apache.cxf.transport.http.ServerEngine;
import org.apache.cxf.transport.http.ServiceModelHttpConfigurationProvider;
import org.apache.cxf.transport.http.URLConnectionFactory;
import org.apache.cxf.transport.http.conduit.HTTPConduitConfigBean;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.handler.AbstractHttpHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPConduit
extends HTTPConduitConfigBean
implements Conduit {
    public static final String HTTP_CONNECTION = "http.connection";
    public static final String HTTP_DECOUPLED_ENDPOINT = "http.decoupled.endpoint";
    private static final Logger LOG = LogUtils.getL7dLogger(HTTPConduit.class);
    private final Bus bus;
    private final URLConnectionFactory alternateConnectionFactory;
    private URLConnectionFactory connectionFactory;
    private URL url;
    private MessageObserver incomingObserver;
    private EndpointReferenceType target;
    private ServerEngine decoupledEngine;
    private URL decoupledURL;
    private DecoupledDestination decoupledDestination;
    private EndpointInfo endpointInfo;

    public HTTPConduit(Bus b, EndpointInfo ei) throws IOException {
        this(b, ei, null);
    }

    public HTTPConduit(Bus b, EndpointInfo ei, EndpointReferenceType t) throws IOException {
        this(b, ei, t, null, null);
    }

    public HTTPConduit(Bus b, EndpointInfo ei, EndpointReferenceType t, URLConnectionFactory factory, ServerEngine eng) throws IOException {
        this.init();
        this.bus = b;
        this.endpointInfo = ei;
        this.alternateConnectionFactory = factory;
        this.decoupledEngine = eng;
        this.url = t == null ? new URL(this.getAddress()) : new URL(t.getAddress().getValue());
        this.target = this.getTargetReference(t);
    }

    protected void retrieveConnectionFactory() {
        this.connectionFactory = this.alternateConnectionFactory != null ? this.alternateConnectionFactory : HTTPTransportFactory.getConnectionFactory(this.sslClient);
    }

    public String getBeanName() {
        return this.endpointInfo.getName().toString() + ".http-conduit";
    }

    public void setMessageObserver(MessageObserver observer) {
        this.incomingObserver = observer;
        LOG.info("registering incoming observer: " + this.incomingObserver);
    }

    public void send(Message message) throws IOException {
        Map<String, List<String>> headers = this.setHeaders(message);
        URL currentURL = this.setupURL(message);
        URLConnection connection = this.connectionFactory.createConnection(this.getProxy(), currentURL);
        connection.setDoOutput(true);
        connection.setConnectTimeout((int)this.getClient().getConnectionTimeout());
        connection.setReadTimeout((int)this.getClient().getReceiveTimeout());
        connection.setUseCaches(false);
        if (null != message.get((Object)Message.CONTENT_TYPE)) {
            connection.setRequestProperty("Content-Type", (String)message.get((Object)Message.CONTENT_TYPE));
        } else {
            connection.setRequestProperty("Content-Type", "text/xml");
        }
        if (connection instanceof HttpURLConnection) {
            String httpRequestMethod = (String)message.get((Object)Message.HTTP_REQUEST_METHOD);
            HttpURLConnection hc = (HttpURLConnection)connection;
            if (null != httpRequestMethod) {
                hc.setRequestMethod(httpRequestMethod);
            } else {
                hc.setRequestMethod("POST");
            }
            if (this.getClient().isAutoRedirect()) {
                hc.setInstanceFollowRedirects(true);
            } else {
                hc.setInstanceFollowRedirects(false);
                if (!hc.getRequestMethod().equals("GET") && this.client.isAllowChunking()) {
                    hc.setChunkedStreamingMode(2048);
                }
            }
        }
        message.put((Object)HTTP_CONNECTION, (Object)connection);
        this.setPolicies(message, headers);
        message.setContent(OutputStream.class, (Object)new WrappedOutputStream(message, connection));
    }

    private URL setupURL(Message message) throws MalformedURLException {
        String result;
        String value = (String)message.get((Object)Message.ENDPOINT_ADDRESS);
        String pathInfo = (String)message.get((Object)Message.PATH_INFO);
        String queryString = (String)message.get((Object)Message.QUERY_STRING);
        String string = result = value != null ? value : this.url.toString();
        if (null != pathInfo && !result.endsWith(pathInfo)) {
            result = result + pathInfo;
        }
        if (queryString != null) {
            result = result + "?" + queryString;
        }
        return new URL(result);
    }

    public EndpointReferenceType getTarget() {
        return this.target;
    }

    public synchronized Destination getBackChannel() {
        if (this.decoupledDestination == null && this.getConfiguredDecoupledEndpoint() != null) {
            this.decoupledDestination = this.setUpDecoupledDestination();
        }
        return this.decoupledDestination;
    }

    public void close(Message msg) throws IOException {
        ((OutputStream)msg.getContent(OutputStream.class)).close();
    }

    public void close() {
        DecoupledHandler decoupledHandler;
        if (this.url != null) {
            try {
                URLConnection connect = this.url.openConnection();
                if (connect instanceof HttpURLConnection) {
                    ((HttpURLConnection)connect).disconnect();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.url = null;
        }
        if (this.decoupledURL != null && this.decoupledEngine != null && (decoupledHandler = (DecoupledHandler)this.decoupledEngine.getServant(this.decoupledURL)) != null) {
            decoupledHandler.release();
        }
    }

    protected URL getURL() {
        return this.url;
    }

    private EndpointReferenceType getTargetReference(EndpointReferenceType t) {
        EndpointReferenceType ref = null;
        if (null == t) {
            ref = new EndpointReferenceType();
            AttributedURIType address = new AttributedURIType();
            address.setValue(this.getAddress());
            ref.setAddress(address);
        } else {
            ref = t;
        }
        return ref;
    }

    private Map<String, List<String>> setHeaders(Message message) {
        HashMap headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (null == headers) {
            headers = new HashMap();
            message.put((Object)Message.PROTOCOL_HEADERS, headers);
        }
        return headers;
    }

    protected void flushHeaders(Message message) throws IOException {
        Map headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        URLConnection connection = (URLConnection)message.get((Object)HTTP_CONNECTION);
        if (null != headers) {
            for (String header : headers.keySet()) {
                List headerList = (List)headers.get(header);
                for (String value : headerList) {
                    connection.addRequestProperty(header, value);
                }
            }
        }
    }

    private int getResponseCode(URLConnection connection) throws IOException {
        int responseCode = 200;
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection hc = (HttpURLConnection)connection;
            responseCode = hc.getResponseCode();
        } else if (connection.getHeaderField(Message.RESPONSE_CODE) != null) {
            responseCode = Integer.parseInt(connection.getHeaderField(Message.RESPONSE_CODE));
        }
        return responseCode;
    }

    private DecoupledDestination setUpDecoupledDestination() {
        EndpointReferenceType reference = EndpointReferenceUtils.getEndpointReference((String)this.getConfiguredDecoupledEndpoint());
        if (reference != null) {
            String decoupledAddress = reference.getAddress().getValue();
            LOG.info("creating decoupled endpoint: " + decoupledAddress);
            try {
                DecoupledHandler decoupledHandler;
                this.decoupledURL = new URL(decoupledAddress);
                if (this.decoupledEngine == null) {
                    this.decoupledEngine = JettyHTTPServerEngine.getForPort(this.bus, this.decoupledURL.getProtocol(), this.decoupledURL.getPort());
                }
                if ((decoupledHandler = (DecoupledHandler)this.decoupledEngine.getServant(this.decoupledURL)) == null) {
                    decoupledHandler = new DecoupledHandler();
                    this.decoupledEngine.addServant(this.decoupledURL, decoupledHandler);
                }
                decoupledHandler.duplicate();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "decoupled endpoint creation failed: ", e);
            }
        }
        return new DecoupledDestination(reference, this.incomingObserver);
    }

    private String getConfiguredDecoupledEndpoint() {
        return this.getClient().getDecoupledEndpoint() != null ? this.getClient().getDecoupledEndpoint() : System.getProperty(HTTP_DECOUPLED_ENDPOINT);
    }

    private void init() {
        ArrayList<ServiceModelHttpConfigurationProvider> providers;
        if (!this.isSetClient()) {
            this.setClient(new HTTPClientPolicy());
        }
        if (!this.isSetAuthorization()) {
            this.setAuthorization(new AuthorizationPolicy());
        }
        if (!this.isSetProxyAuthorization()) {
            this.setProxyAuthorization(new AuthorizationPolicy());
        }
        if (null == (providers = this.getOverwriteProviders())) {
            providers = new ArrayList<ServiceModelHttpConfigurationProvider>();
        }
        ServiceModelHttpConfigurationProvider p = new ServiceModelHttpConfigurationProvider(this.endpointInfo, false);
        providers.add(p);
        this.setOverwriteProviders(providers);
    }

    private String getAddress() {
        return this.endpointInfo.getAddress();
    }

    private Proxy getProxy() {
        Proxy proxy = null;
        HTTPClientPolicy policy = this.getClient();
        if (policy.isSetProxyServer()) {
            proxy = new Proxy(Proxy.Type.valueOf(policy.getProxyServerType().toString()), new InetSocketAddress(policy.getProxyServer(), policy.getProxyServerPort()));
        }
        return proxy;
    }

    private void setPolicies(Message message, Map<String, List<String>> headers) {
        HTTPClientPolicy policy;
        AuthorizationPolicy authPolicy = this.getAuthorization();
        AuthorizationPolicy newPolicy = (AuthorizationPolicy)message.get(AuthorizationPolicy.class);
        String userName = (String)message.get((Object)Message.USERNAME);
        String passwd = (String)message.get((Object)Message.PASSWORD);
        if (null != newPolicy && null != userName) {
            userName = newPolicy.getUserName();
            passwd = newPolicy.getPassword();
        }
        if (userName == null && authPolicy.isSetUserName()) {
            userName = authPolicy.getUserName();
        }
        if (userName != null) {
            if (passwd == null && authPolicy.isSetPassword()) {
                passwd = authPolicy.getPassword();
            }
            userName = userName + ":";
            if (passwd != null) {
                userName = userName + passwd;
            }
            userName = Base64Utility.encode((byte[])userName.getBytes());
            headers.put("Authorization", Arrays.asList("Basic " + userName));
        } else if (authPolicy.isSetAuthorizationType() && authPolicy.isSetAuthorization()) {
            String type = authPolicy.getAuthorizationType();
            type = type + " ";
            type = type + authPolicy.getAuthorization();
            headers.put("Authorization", Arrays.asList(type));
        }
        AuthorizationPolicy proxyAuthPolicy = this.getProxyAuthorization();
        if (proxyAuthPolicy.isSetUserName()) {
            userName = proxyAuthPolicy.getUserName();
            if (userName != null) {
                passwd = "";
                if (proxyAuthPolicy.isSetPassword()) {
                    passwd = proxyAuthPolicy.getPassword();
                }
                userName = userName + ":";
                if (passwd != null) {
                    userName = userName + passwd;
                }
                userName = Base64Utility.encode((byte[])userName.getBytes());
                headers.put("Proxy-Authorization", Arrays.asList("Basic " + userName));
            } else if (proxyAuthPolicy.isSetAuthorizationType() && proxyAuthPolicy.isSetAuthorization()) {
                String type = proxyAuthPolicy.getAuthorizationType();
                type = type + " ";
                type = type + proxyAuthPolicy.getAuthorization();
                headers.put("Proxy-Authorization", Arrays.asList(type));
            }
        }
        if ((policy = this.getClient()).isSetCacheControl()) {
            headers.put("Cache-Control", Arrays.asList(policy.getCacheControl().value()));
        }
        if (policy.isSetHost()) {
            headers.put("Host", Arrays.asList(policy.getHost()));
        }
        if (policy.isSetConnection()) {
            headers.put("Connection", Arrays.asList(policy.getConnection().value()));
        }
        if (policy.isSetAccept()) {
            headers.put("Accept", Arrays.asList(policy.getAccept()));
        }
        if (policy.isSetAcceptEncoding()) {
            headers.put("Accept-Encoding", Arrays.asList(policy.getAcceptEncoding()));
        }
        if (policy.isSetAcceptLanguage()) {
            headers.put("Accept-Language", Arrays.asList(policy.getAcceptLanguage()));
        }
        if (policy.isSetContentType()) {
            headers.put("Content-Type", Arrays.asList(policy.getContentType()));
        }
        if (policy.isSetCookie()) {
            headers.put("Cookie", Arrays.asList(policy.getCookie()));
        }
        if (policy.isSetBrowserType()) {
            headers.put("BrowserType", Arrays.asList(policy.getBrowserType()));
        }
        if (policy.isSetReferer()) {
            headers.put("Referer", Arrays.asList(policy.getReferer()));
        }
    }

    private class DecoupledHandler
    extends AbstractHttpHandler {
        private int refCount;

        private DecoupledHandler() {
        }

        synchronized void duplicate() {
            ++this.refCount;
        }

        synchronized void release() {
            if (--this.refCount == 0) {
                HTTPConduit.this.decoupledEngine.removeServant(HTTPConduit.this.decoupledURL);
                JettyHTTPServerEngine.destroyForPort(HTTPConduit.this.decoupledURL.getPort());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String pathInContext, String pathParams, HttpRequest req, HttpResponse resp) throws IOException {
            InputStream responseStream = req.getInputStream();
            MessageImpl inMessage = new MessageImpl();
            inMessage.setExchange((Exchange)new ExchangeImpl());
            inMessage.put((Object)"decoupled.channel.message", (Object)Boolean.TRUE);
            HTTPConduit.this.setHeaders((Message)inMessage);
            inMessage.put((Object)Message.RESPONSE_CODE, (Object)200);
            WrapperInputStream is = new WrapperInputStream(responseStream, req, resp);
            inMessage.setContent(InputStream.class, (Object)is);
            try {
                HTTPConduit.this.decoupledDestination.getMessageObserver().onMessage((Message)inMessage);
            }
            finally {
                ((InputStream)is).close();
            }
        }
    }

    protected class DecoupledDestination
    implements Destination {
        protected MessageObserver decoupledMessageObserver;
        private EndpointReferenceType address;

        DecoupledDestination(EndpointReferenceType ref, MessageObserver incomingObserver) {
            this.address = ref;
            this.decoupledMessageObserver = incomingObserver;
        }

        public EndpointReferenceType getAddress() {
            return this.address;
        }

        public Conduit getBackChannel(Message inMessage, Message partialResponse, EndpointReferenceType addr) throws IOException {
            return null;
        }

        public void shutdown() {
        }

        public synchronized void setMessageObserver(MessageObserver observer) {
            this.decoupledMessageObserver = observer;
        }

        protected synchronized MessageObserver getMessageObserver() {
            return this.decoupledMessageObserver;
        }
    }

    private class WrapperInputStream
    extends FilterInputStream {
        HttpRequest request;
        HttpResponse response;
        boolean closed;

        WrapperInputStream(InputStream is, HttpRequest req, HttpResponse resp) {
            super(is);
            this.request = req;
            this.response = resp;
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                this.response.commit();
                this.request.setHandled(true);
            }
        }
    }

    private class WrappedOutputStream
    extends AbstractWrappedOutputStream {
        protected URLConnection connection;

        WrappedOutputStream(Message m, URLConnection c) {
            super(m);
            this.connection = c;
        }

        protected void doFlush() throws IOException {
            if (!this.alreadyFlushed()) {
                HttpURLConnection hc;
                HTTPConduit.this.flushHeaders(this.outMessage);
                if (this.connection instanceof HttpURLConnection && (hc = (HttpURLConnection)this.connection).getRequestMethod().equals("GET")) {
                    return;
                }
                this.resetOut(this.connection.getOutputStream(), true);
            }
        }

        protected void doClose() throws IOException {
            this.handleResponse();
        }

        protected void onWrite() throws IOException {
        }

        private void handleResponse() throws IOException {
            Exchange exchange = this.outMessage.getExchange();
            int responseCode = HTTPConduit.this.getResponseCode(this.connection);
            if (exchange != null && exchange.isOneWay() && responseCode != 202) {
                this.connection.getInputStream().close();
                return;
            }
            MessageImpl inMessage = new MessageImpl();
            inMessage.setExchange(exchange);
            InputStream in = null;
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            for (String key : this.connection.getHeaderFields().keySet()) {
                headers.put(HttpHeaderHelper.getHeaderKey((String)key), this.connection.getHeaderFields().get(key));
            }
            inMessage.put((Object)Message.PROTOCOL_HEADERS, headers);
            inMessage.put((Object)Message.RESPONSE_CODE, (Object)responseCode);
            if (this.connection instanceof HttpURLConnection) {
                HttpURLConnection hc = (HttpURLConnection)this.connection;
                in = hc.getErrorStream();
                if (null == in) {
                    in = this.connection.getInputStream();
                }
            } else {
                in = this.connection.getInputStream();
            }
            inMessage.setContent(InputStream.class, (Object)in);
            HTTPConduit.this.incomingObserver.onMessage((Message)inMessage);
        }
    }
}

