/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.io.AbstractWrappedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.JettyHTTPServerEngine;
import org.apache.cxf.transport.http.ServerEngine;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.apache.cxf.wsdl11.ServiceWSDLBuilder;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.handler.AbstractHttpHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyHTTPDestination
extends AbstractHTTPDestination {
    public static final String HTTP_REQUEST = JettyHTTPDestination.class.getName() + ".REQUEST";
    public static final String HTTP_RESPONSE = JettyHTTPDestination.class.getName() + ".RESPONSE";
    protected static final String ANONYMOUS_ADDRESS = "http://www.w3.org/2005/08/addressing/anonymous";
    protected ServerEngine engine;
    protected ServerEngine alternateEngine;
    protected MessageObserver incomingObserver;

    public JettyHTTPDestination(Bus b, ConduitInitiator ci, EndpointInfo endpointInfo) throws IOException {
        this(b, ci, endpointInfo, null);
    }

    public JettyHTTPDestination(Bus b, ConduitInitiator ci, EndpointInfo endpointInfo, ServerEngine eng) throws IOException {
        super(b, ci, endpointInfo);
        this.alternateEngine = eng;
    }

    protected void retrieveEngine() {
        this.engine = this.alternateEngine != null ? this.alternateEngine : JettyHTTPServerEngine.getForPort(this.bus, this.nurl.getProtocol(), this.nurl.getPort(), this.sslServer);
    }

    public synchronized void setMessageObserver(MessageObserver observer) {
        block5: {
            if (null != observer) {
                LOG.info("registering incoming observer: " + observer);
                try {
                    URL url = new URL(this.getAddressValue());
                    if (this.contextMatchOnExact()) {
                        this.engine.addServant(url, new AbstractHttpHandler(){

                            public void handle(String pathInContext, String pathParams, HttpRequest req, HttpResponse resp) throws IOException {
                                if (pathInContext.equals(this.getName())) {
                                    JettyHTTPDestination.this.doService(req, resp);
                                }
                            }
                        });
                        break block5;
                    }
                    this.engine.addServant(url, new AbstractHttpHandler(){

                        public void handle(String pathInContext, String pathParams, HttpRequest req, HttpResponse resp) throws IOException {
                            if (pathInContext.startsWith(this.getName())) {
                                JettyHTTPDestination.this.doService(req, resp);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "URL creation failed: ", e);
                }
            } else {
                LOG.info("unregistering incoming observer: " + this.incomingObserver);
                this.engine.removeServant(this.nurl);
            }
        }
        this.incomingObserver = observer;
    }

    public Conduit getBackChannel(Message inMessage, Message partialResponse, EndpointReferenceType address) throws IOException {
        EndpointReferenceType target;
        HttpResponse response = (HttpResponse)inMessage.get((Object)HTTP_RESPONSE);
        BackChannelConduit backChannel = null;
        Exchange ex = inMessage.getExchange();
        EndpointReferenceType endpointReferenceType = target = address != null ? address : (EndpointReferenceType)ex.get(EndpointReferenceType.class);
        if (target == null) {
            backChannel = new BackChannelConduit(response);
        } else if (partialResponse != null) {
            partialResponse.put((Object)Message.RESPONSE_CODE, (Object)202);
            backChannel = new BackChannelConduit(response);
            ex.put(EndpointReferenceType.class, (Object)target);
        } else {
            backChannel = this.conduitInitiator.getConduit(this.endpointInfo, target);
            backChannel.setMessageObserver(new MessageObserver(){

                public void onMessage(Message m) {
                    if (m.getContentFormats().contains(InputStream.class)) {
                        InputStream is = (InputStream)m.getContent(InputStream.class);
                        try {
                            is.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        return backChannel;
    }

    public void shutdown() {
    }

    @Override
    protected void copyRequestHeaders(Message message, Map<String, List<String>> headers) {
        HttpRequest req = (HttpRequest)message.get((Object)HTTP_REQUEST);
        Enumeration e = req.getFieldNames();
        while (e.hasMoreElements()) {
            List<Object> values;
            String fname = (String)e.nextElement();
            if (headers.containsKey(fname)) {
                values = headers.get(fname);
            } else {
                values = new ArrayList();
                headers.put(HttpHeaderHelper.getHeaderKey((String)fname), values);
            }
            Enumeration e2 = req.getFieldValues(fname);
            while (e2.hasMoreElements()) {
                String val = (String)e2.nextElement();
                values.add(val);
            }
        }
    }

    protected void copyResponseHeaders(Message message, HttpResponse response) {
        Map headers = (Map)message.get((Object)Message.PROTOCOL_HEADERS);
        if (null != headers) {
            for (String header : headers.keySet()) {
                List headerList = (List)headers.get(header);
                for (Object value : headerList) {
                    response.addField(header, (String)value);
                }
            }
        }
    }

    protected void doService(HttpRequest req, HttpResponse resp) throws IOException {
        if (this.getServer().isSetRedirectURL()) {
            resp.sendRedirect(this.getServer().getRedirectURL());
            resp.commit();
            req.setHandled(true);
            return;
        }
        if ("GET".equals(req.getMethod()) && req.getURI().toString().toLowerCase().endsWith("?wsdl")) {
            try {
                resp.addField("Content-Type", "text/xml");
                OutputStream os = resp.getOutputStream();
                WSDLWriter wsdlWriter = WSDLFactory.newInstance().newWSDLWriter();
                Definition def = new ServiceWSDLBuilder(this.endpointInfo.getService()).build();
                wsdlWriter.writeWSDL(def, os);
                resp.getOutputStream().flush();
                resp.commit();
                req.setHandled(true);
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.serviceRequest(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceRequest(HttpRequest req, HttpResponse resp) throws IOException {
        try {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Service http request on thread: " + Thread.currentThread());
            }
            MessageImpl inMessage = new MessageImpl();
            inMessage.setContent(InputStream.class, (Object)req.getInputStream());
            inMessage.put((Object)HTTP_REQUEST, (Object)req);
            inMessage.put((Object)HTTP_RESPONSE, (Object)resp);
            inMessage.put((Object)Message.HTTP_REQUEST_METHOD, (Object)req.getMethod());
            inMessage.put((Object)Message.PATH_INFO, (Object)req.getPath());
            inMessage.put((Object)Message.QUERY_STRING, (Object)req.getQuery());
            inMessage.put((Object)Message.CONTENT_TYPE, (Object)req.getContentType());
            if (!StringUtils.isEmpty((String)this.getAddressValue())) {
                inMessage.put((Object)Message.BASE_PATH, (Object)new URL(this.getAddressValue()).getPath());
            }
            inMessage.put((Object)Message.FIXED_PARAMETER_ORDER, (Object)this.isFixedParameterOrder());
            this.setHeaders((Message)inMessage);
            inMessage.setDestination((Destination)this);
            this.incomingObserver.onMessage((Message)inMessage);
            resp.commit();
            req.setHandled(true);
        }
        finally {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Finished servicing http request on thread: " + Thread.currentThread());
            }
        }
    }

    protected OutputStream flushHeaders(Message outMessage) throws IOException {
        this.updateResponseHeaders(outMessage);
        Object responseObj = outMessage.get((Object)HTTP_RESPONSE);
        OutputStream responseStream = null;
        if (responseObj instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)responseObj;
            Integer i = (Integer)outMessage.get((Object)Message.RESPONSE_CODE);
            if (i != null) {
                int status = i;
                if (status == 500) {
                    response.setStatus(status, "Fault Occurred");
                } else if (status == 202) {
                    response.setStatus(status, "Accepted");
                } else {
                    response.setStatus(status);
                }
            } else {
                response.setStatus(200);
            }
            this.copyResponseHeaders(outMessage, response);
            responseStream = response.getOutputStream();
            if (this.isOneWay(outMessage)) {
                response.commit();
            }
        } else {
            if (null != responseObj) {
                String m = new org.apache.cxf.common.i18n.Message("UNEXPECTED_RESPONSE_TYPE_MSG", LOG, new Object[]{responseObj.getClass()}).toString();
                LOG.log(Level.WARNING, m);
                throw new IOException(m);
            }
            String m = new org.apache.cxf.common.i18n.Message("NULL_RESPONSE_MSG", LOG, new Object[0]).toString();
            LOG.log(Level.WARNING, m);
            throw new IOException(m);
        }
        if (this.isOneWay(outMessage)) {
            outMessage.remove((Object)HTTP_RESPONSE);
        }
        return responseStream;
    }

    private class WrappedOutputStream
    extends AbstractWrappedOutputStream {
        protected HttpResponse response;

        WrappedOutputStream(Message m, HttpResponse resp) {
            super(m);
            this.response = resp;
        }

        protected void doFlush() throws IOException {
            OutputStream responseStream = JettyHTTPDestination.this.flushHeaders(this.outMessage);
            if (null != responseStream && !this.alreadyFlushed()) {
                this.resetOut(responseStream, true);
            }
        }

        protected void doClose() {
            this.commitResponse();
        }

        protected void onWrite() throws IOException {
        }

        private void commitResponse() {
            try {
                this.response.commit();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected class BackChannelConduit
    implements Conduit {
        protected HttpResponse response;
        protected EndpointReferenceType target;

        BackChannelConduit(HttpResponse resp) {
            this.response = resp;
            this.target = EndpointReferenceUtils.getEndpointReference((String)JettyHTTPDestination.ANONYMOUS_ADDRESS);
        }

        public void close(Message msg) throws IOException {
            ((OutputStream)msg.getContent(OutputStream.class)).close();
        }

        public void setMessageObserver(MessageObserver observer) {
        }

        public void send(Message message) throws IOException {
            message.put((Object)HTTP_RESPONSE, (Object)this.response);
            message.setContent(OutputStream.class, (Object)new WrappedOutputStream(message, this.response));
        }

        public EndpointReferenceType getTarget() {
            return this.target;
        }

        public Destination getBackChannel() {
            return null;
        }

        public void close() {
        }
    }
}

