/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.https;

import java.util.logging.Handler;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.security.SSLServerPolicy;
import org.apache.cxf.transport.http.JettyListenerFactory;
import org.apache.cxf.transport.https.SSLUtils;
import org.mortbay.http.SocketListener;
import org.mortbay.http.SslListener;
import org.mortbay.util.InetAddrPort;

public final class JettySslListenerFactory
implements JettyListenerFactory {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogUtils.getL7dLogger(JettySslListenerFactory.class);
    private static final String[] UNSUPPORTED = new String[]{"SessionCaching", "SessionCacheKey", "MaxChainLength", "CertValidator", "TrustStoreAlgorithm", "TrustStoreType"};
    SSLServerPolicy sslPolicy;

    public JettySslListenerFactory(SSLServerPolicy policy) {
        this.sslPolicy = policy;
    }

    public SocketListener createListener(int port) {
        SslListener secureListener = new SslListener(new InetAddrPort(port));
        this.decorate(secureListener);
        return secureListener;
    }

    public void decorate(SslListener secureListener) {
        secureListener.setKeystore(SSLUtils.getKeystore(this.sslPolicy.getKeystore(), LOG));
        secureListener.setKeystoreType(SSLUtils.getKeystoreType(this.sslPolicy.getKeystoreType(), LOG));
        secureListener.setPassword(SSLUtils.getKeystorePassword(this.sslPolicy.getKeystorePassword(), LOG));
        secureListener.setKeyPassword(SSLUtils.getKeyPassword(this.sslPolicy.getKeyPassword(), LOG));
        secureListener.setAlgorithm(SSLUtils.getKeystoreAlgorithm(this.sslPolicy.getKeystoreAlgorithm(), LOG));
        secureListener.setCipherSuites(SSLUtils.getCiphersuites(this.sslPolicy.getCiphersuites(), LOG));
        System.setProperty("javax.net.ssl.trustStore", SSLUtils.getTrustStore(this.sslPolicy.getTrustStore(), LOG));
        secureListener.setProtocol(SSLUtils.getSecureSocketProtocol(this.sslPolicy.getSecureSocketProtocol(), LOG));
        secureListener.setWantClientAuth(SSLUtils.getWantClientAuthentication(this.sslPolicy.isSetWantClientAuthentication(), this.sslPolicy.isWantClientAuthentication(), LOG));
        secureListener.setNeedClientAuth(SSLUtils.getRequireClientAuthentication(this.sslPolicy.isSetRequireClientAuthentication(), this.sslPolicy.isRequireClientAuthentication(), LOG));
        SSLUtils.logUnSupportedPolicies(this.sslPolicy, false, UNSUPPORTED, LOG);
    }

    protected void addLogHandler(Handler handler) {
        LOG.addHandler(handler);
    }

    protected String[] getUnSupported() {
        return UNSUPPORTED;
    }
}

